/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.util.iter;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<T>
implements Iterator<T> {
    private final T[] array;
    private int count;

    public ArrayIterator(T[] array) {
        this(array, true);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ArrayIterator(T[] array, boolean makeDefensiveCopy) {
        if (array == null) {
            throw new NullPointerException("array can not be null");
        }
        this.array = makeDefensiveCopy ? Arrays.copyOf(array, array.length) : array;
    }

    @Override
    public boolean hasNext() {
        return this.count < this.array.length;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.array[this.count++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }
}

