/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.util;

import java.util.Arrays;
import org.jcvi.jillion.core.io.IOUtil;

public class UnsignedShortArray {
    private final short[] array;

    public UnsignedShortArray(short[] array) {
        if (array == null) {
            throw new NullPointerException("array can not be null");
        }
        this.array = Arrays.copyOf(array, array.length);
    }

    public int getLength() {
        return this.array.length;
    }

    public int get(int i) {
        return IOUtil.toUnsignedShort(this.array[i]);
    }

    public void put(int i, int value) {
        this.array[i] = IOUtil.toSignedShort(value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnsignedShortArray)) {
            return false;
        }
        UnsignedShortArray other = (UnsignedShortArray)obj;
        return Arrays.equals(this.array, other.array);
    }
}

