/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.util;

import java.util.Arrays;
import org.jcvi.jillion.core.io.IOUtil;

public class UnsignedIntArray {
    private final int[] array;

    public UnsignedIntArray(int[] array) {
        if (array == null) {
            throw new NullPointerException("array can not be null");
        }
        this.array = Arrays.copyOf(array, array.length);
    }

    public int getLength() {
        return this.array.length;
    }

    public long get(int i) {
        return IOUtil.toUnsignedInt(this.array[i]);
    }

    public void put(int i, long value) {
        this.array[i] = IOUtil.toSignedInt(value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnsignedIntArray)) {
            return false;
        }
        UnsignedIntArray other = (UnsignedIntArray)obj;
        return Arrays.equals(this.array, other.array);
    }
}

