/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.util;

import java.util.Arrays;
import org.jcvi.jillion.core.io.IOUtil;

public class UnsignedByteArray {
    private final byte[] array;

    public UnsignedByteArray(byte[] array) {
        if (array == null) {
            throw new NullPointerException("array can not be null");
        }
        this.array = Arrays.copyOf(array, array.length);
    }

    public int getLength() {
        return this.array.length;
    }

    public int get(int i) {
        return IOUtil.toUnsignedByte(this.array[i]);
    }

    public void put(int i, int value) {
        this.array[i] = IOUtil.toSignedByte(value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnsignedByteArray)) {
            return false;
        }
        UnsignedByteArray other = (UnsignedByteArray)obj;
        return Arrays.equals(this.array, other.array);
    }
}

