/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.util;

import java.io.Closeable;
import java.util.Objects;
import java.util.function.Supplier;
import org.jcvi.jillion.core.io.IOUtil;

public class Pair<T, U>
implements AutoCloseable {
    private final Supplier<T> first;
    private final Supplier<U> second;

    public Pair(T first, U second) {
        this.first = () -> first;
        this.second = () -> second;
    }

    public Pair(Supplier<T> first, Supplier<U> second) {
        this.first = Objects.requireNonNull(first);
        this.second = Objects.requireNonNull(second);
    }

    public T getFirst() {
        return this.first.get();
    }

    public U getSecond() {
        return this.second.get();
    }

    @Override
    public void close() {
        if (this.first instanceof Closeable) {
            IOUtil.closeAndIgnoreErrors((Closeable)((Object)this.first));
        }
        if (this.second instanceof Closeable) {
            IOUtil.closeAndIgnoreErrors((Closeable)((Object)this.second));
        }
    }
}

