/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class MultipleWrapper<T>
implements InvocationHandler {
    private final ReturnPolicy policy;
    private final List<T> delegates = new ArrayList<T>();

    public static <T> T createMultipleWrapper(Class<T> classType, ReturnPolicy policy, Iterable<? extends T> delegates) {
        return (T)Proxy.newProxyInstance(classType.getClassLoader(), new Class[]{classType}, new MultipleWrapper<T>(policy, delegates));
    }

    public static <T> T createMultipleWrapper(Class<T> classType, Iterable<? extends T> delegates) {
        return MultipleWrapper.createMultipleWrapper(classType, ReturnPolicy.RETURN_FIRST, delegates);
    }

    @SafeVarargs
    public static <T> T createMultipleWrapper(Class<T> classType, T ... delegates) {
        return MultipleWrapper.createMultipleWrapper(classType, ReturnPolicy.RETURN_FIRST, Arrays.asList(delegates));
    }

    @SafeVarargs
    public static <T> T createMultipleWrapper(Class<T> classType, ReturnPolicy policy, T ... delegates) {
        return MultipleWrapper.createMultipleWrapper(classType, policy, Arrays.asList(delegates));
    }

    private MultipleWrapper(ReturnPolicy policy, Iterable<? extends T> delegates) {
        if (policy == null) {
            throw new NullPointerException("policy can not be null");
        }
        this.policy = policy;
        for (T delegate : delegates) {
            if (delegate == null) {
                throw new NullPointerException("delegate can not be null");
            }
            this.delegates.add(delegate);
        }
        if (this.delegates.size() == 0) {
            throw new IllegalArgumentException("must wrap at least one delegate");
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ArrayList<Object> returns = new ArrayList<Object>(this.delegates.size());
        try {
            for (T delegate : this.delegates) {
                returns.add(method.invoke(delegate, args));
            }
            if (this.policy == ReturnPolicy.RETURN_LAST) {
                return returns.get(returns.size() - 1);
            }
            return returns.get(0);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public static enum ReturnPolicy {
        RETURN_FIRST,
        RETURN_LAST;

    }
}

