/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.util;

import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jcvi.jillion.internal.core.util.ComparableComparator;

public final class MapValueComparator<K extends Comparable<? super K>, V>
implements Comparator<K> {
    private final Map<K, V> map;
    private final boolean ascending;
    private final Comparator<V> valueComparator;

    public static <K extends Comparable<? super K>, V> SortedMap<K, V> sortAscending(Map<K, V> unsorted, Comparator<V> comparator) {
        TreeMap<K, V> sorted = new TreeMap<K, V>(MapValueComparator.create(unsorted, comparator, true));
        sorted.putAll(unsorted);
        return sorted;
    }

    public static <K extends Comparable<? super K>, V> SortedMap<K, V> sortDescending(Map<K, V> unsorted, Comparator<V> comparator) {
        TreeMap<K, V> sorted = new TreeMap<K, V>(MapValueComparator.create(unsorted, comparator, false));
        sorted.putAll(unsorted);
        return sorted;
    }

    public static <K extends Comparable<? super K>, V extends Comparable<? super V>> SortedMap<K, V> sortAscending(Map<K, V> unsorted) {
        if (unsorted == null) {
            throw new NullPointerException("map can not be null");
        }
        TreeMap<K, V> sorted = new TreeMap<K, V>(MapValueComparator.create(unsorted, ComparableComparator.create(), true));
        sorted.putAll(unsorted);
        return sorted;
    }

    public static <K extends Comparable<? super K>, V extends Comparable<? super V>> SortedMap<K, V> sortDescending(Map<K, V> unsorted) {
        if (unsorted == null) {
            throw new NullPointerException("map can not be null");
        }
        TreeMap<K, V> sorted = new TreeMap<K, V>(MapValueComparator.create(unsorted, ComparableComparator.create(), false));
        sorted.putAll(unsorted);
        return sorted;
    }

    private static <K extends Comparable<? super K>, V> MapValueComparator<K, V> create(Map<K, V> map, Comparator<V> comparator, boolean ascending) {
        return new MapValueComparator<K, V>(map, comparator, ascending);
    }

    private MapValueComparator(Map<K, V> map, Comparator<V> valueComparator, boolean ascending) {
        if (map == null) {
            throw new NullPointerException("map can not be null");
        }
        this.map = map;
        this.valueComparator = valueComparator;
        this.ascending = ascending;
    }

    @Override
    public int compare(K o1, K o2) {
        if (this.ascending) {
            return this.privateCompare(o1, o2);
        }
        return this.privateCompare(o2, o1);
    }

    private int privateCompare(K o1, K o2) {
        if (!this.map.containsKey(o1)) {
            if (!this.map.containsKey(o2)) {
                return 0;
            }
            return -1;
        }
        if (!this.map.containsKey(o2)) {
            return 1;
        }
        int comp = this.valueComparator.compare(this.map.get(o1), this.map.get(o2));
        if (comp != 0) {
            return comp;
        }
        return o1.compareTo(o2);
    }
}

