/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.util;

public final class MapUtil {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;

    private MapUtil() {
    }

    public static int computeMinHashMapSizeWithoutRehashing(long expectedNumberOfEntries) {
        return MapUtil.computeMinHashMapSizeWithoutRehashing(expectedNumberOfEntries, 0.75f);
    }

    public static int computeMinHashMapSizeWithoutRehashing(long expectedNumberOfEntries, float loadFactor) {
        if (expectedNumberOfEntries < 0L) {
            throw new IllegalArgumentException("number of entries must be >=0");
        }
        if (expectedNumberOfEntries > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("number of entries must be <= Integer.MAX_VALUE");
        }
        if (loadFactor < 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("invalid load factor, must be between 0 and 1 : " + loadFactor);
        }
        return (int)((float)expectedNumberOfEntries / loadFactor + 1.0f);
    }
}

