/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import org.jcvi.jillion.core.util.Builder;

public final class JoinedStringBuilder<T>
implements Builder<String> {
    private final Iterable<T> elements;
    private Object glue;
    private Object prefix;
    private Object suffix;
    private boolean includeEmptyStrings = false;
    private Function<T, String> valueTransformer = Object::toString;

    public static <T> JoinedStringBuilder<T> create(Iterable<T> elements) {
        return new JoinedStringBuilder<T>(elements);
    }

    @SafeVarargs
    public static <T> JoinedStringBuilder<T> create(T ... elements) {
        return new JoinedStringBuilder<T>(elements);
    }

    JoinedStringBuilder(Iterable<T> elements) {
        this.elements = elements;
    }

    @SafeVarargs
    JoinedStringBuilder(T ... elements) {
        this((Iterable<T>)Arrays.asList(elements));
    }

    public JoinedStringBuilder<T> glue(Object glue) {
        this.glue = glue;
        return this;
    }

    public JoinedStringBuilder<T> prefix(Object prefix) {
        this.prefix = prefix;
        return this;
    }

    public JoinedStringBuilder<T> includeEmptyStrings(boolean value) {
        this.includeEmptyStrings = value;
        return this;
    }

    public JoinedStringBuilder<T> suffix(Object suffix) {
        this.suffix = suffix;
        return this;
    }

    public String toString() {
        return this.build();
    }

    @Override
    public String build() {
        T firstElement;
        Iterator<T> iter;
        StringBuilder joined = new StringBuilder();
        if (this.prefix != null) {
            joined.append(this.prefix);
        }
        if ((iter = this.elements.iterator()).hasNext() && (firstElement = iter.next()) != null) {
            joined.append(this.valueTransformer.apply(firstElement));
        }
        while (iter.hasNext()) {
            T item = iter.next();
            if (item == null) continue;
            String itemString = this.valueTransformer.apply(item);
            if (this.glue != null && joined.length() > 0 && (this.includeEmptyStrings || itemString.length() > 0)) {
                joined.append(this.glue.toString());
            }
            joined.append(itemString);
        }
        if (this.suffix != null) {
            joined.append(this.suffix);
        }
        return joined.toString();
    }

    public JoinedStringBuilder<T> transform(Function<T, String> transformer) {
        Objects.requireNonNull(transformer);
        this.valueTransformer = transformer;
        return this;
    }
}

