/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.util;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collector;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.internal.core.util.BoundedPriorityQueue;

public class JillionCollectors {
    public static <T extends Comparable<? super T>> Collector<T, ?, List<T>> topN(int n) {
        return JillionCollectors.topN(n, Comparator.naturalOrder());
    }

    public static <T> Collector<T, ?, List<T>> topN(int n, Comparator<T> comparator) {
        return Collector.of(() -> BoundedPriorityQueue.create(n, comparator), AbstractQueue::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, q -> new ArrayList(q), new Collector.Characteristics[0]);
    }

    public static <T, D extends DataStore<T>> Collector<T, ?, D> toDataStore(Class<D> cls, Function<T, String> idFunction) {
        Objects.requireNonNull(cls);
        Objects.requireNonNull(idFunction);
        return Collector.of(() -> new LinkedHashMap(), (m, r) -> m.put(Objects.requireNonNull(idFunction.apply(r)), r), (left, right) -> {
            left.putAll(right);
            return left;
        }, m -> DataStore.of(m, cls), new Collector.Characteristics[0]);
    }
}

