/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.util;

import java.util.Collections;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.jcvi.jillion.internal.core.util.GrowableIntArray;

public final class GenomeStatistics {
    private GenomeStatistics() {
    }

    public static OptionalInt nX(IntStream stream, double percentage) {
        return stream.collect(() -> GenomeStatistics.nXBuilder(percentage), (builder, v) -> builder.add(v), (a, b) -> a.merge((GenomeStatisticsBuilder)b)).build();
    }

    public static OptionalInt nX(LongStream stream, double percentage) {
        return stream.collect(() -> GenomeStatistics.nXBuilder(percentage), (builder, v) -> builder.add(v), (a, b) -> a.merge((GenomeStatisticsBuilder)b)).build();
    }

    public static OptionalInt n50(IntStream stream) {
        return GenomeStatistics.nX(stream, 0.5);
    }

    public static OptionalInt n50(LongStream stream) {
        return GenomeStatistics.nX(stream, 0.5);
    }

    public static OptionalInt n75(IntStream stream) {
        return GenomeStatistics.nX(stream, 0.75);
    }

    public static OptionalInt n75(LongStream stream) {
        return GenomeStatistics.nX(stream, 0.75);
    }

    public static OptionalInt n90(IntStream stream) {
        return GenomeStatistics.nX(stream, 0.9);
    }

    public static OptionalInt n90(LongStream stream) {
        return GenomeStatistics.nX(stream, 0.9);
    }

    public static OptionalInt ngX(LongStream stream, double percentage, long genomeLength) {
        return stream.collect(() -> GenomeStatistics.ngXBuilder(genomeLength, percentage), (builder, v) -> builder.add(v), (a, b) -> a.merge((GenomeStatisticsBuilder)b)).build();
    }

    public static OptionalInt ngX(IntStream stream, double percentage, long genomeLength) {
        return stream.collect(() -> GenomeStatistics.ngXBuilder(genomeLength, percentage), (builder, v) -> builder.add(v), (a, b) -> a.merge((GenomeStatisticsBuilder)b)).build();
    }

    public static OptionalInt ng50(IntStream stream, long genomeLength) {
        return GenomeStatistics.ngX(stream, 0.5, genomeLength);
    }

    public static OptionalInt ng50(LongStream stream, long genomeLength) {
        return GenomeStatistics.ngX(stream, 0.5, genomeLength);
    }

    public static OptionalInt ng75(IntStream stream, long genomeLength) {
        return GenomeStatistics.ngX(stream, 0.75, genomeLength);
    }

    public static OptionalInt ng75(LongStream stream, long genomeLength) {
        return GenomeStatistics.ngX(stream, 0.75, genomeLength);
    }

    public static OptionalInt ng90(IntStream stream, long genomeLength) {
        return GenomeStatistics.ngX(stream, 0.9, genomeLength);
    }

    public static OptionalInt ng90(LongStream stream, long genomeLength) {
        return GenomeStatistics.ngX(stream, 0.9, genomeLength);
    }

    public static GenomeStatisticsBuilder n50Builder() {
        return new NStatBuilder(0.5);
    }

    public static GenomeStatisticsBuilder n75Builder() {
        return new NStatBuilder(0.75);
    }

    public static GenomeStatisticsBuilder n90Builder() {
        return new NStatBuilder(0.9);
    }

    public static GenomeStatisticsBuilder nXBuilder(double percentage) {
        if (percentage <= 0.0) {
            throw new IllegalArgumentException("percentage must be > 0");
        }
        if (percentage >= 1.0) {
            throw new IllegalArgumentException("percentage must be < 1");
        }
        return new NStatBuilder(percentage);
    }

    public static GenomeStatisticsBuilder ng50Builder(long genomeLength) {
        return new NGStatBuilder(genomeLength, 0.5);
    }

    public static GenomeStatisticsBuilder ng75Builder(long genomeLength) {
        return new NGStatBuilder(genomeLength, 0.75);
    }

    public static GenomeStatisticsBuilder ng90Builder(long genomeLength) {
        return new NGStatBuilder(genomeLength, 0.9);
    }

    public static GenomeStatisticsBuilder ngXBuilder(long genomeLength, double percentage) {
        if (genomeLength <= 0L) {
            throw new IllegalArgumentException("genome length must be > 0");
        }
        if (percentage <= 0.0) {
            throw new IllegalArgumentException("percentage must be > 0");
        }
        if (percentage >= 1.0) {
            throw new IllegalArgumentException("percentage must be < 1");
        }
        return new NGStatBuilder(genomeLength, percentage);
    }

    public static <T extends Number> Collector<T, GenomeStatisticsBuilder, OptionalInt> ng50Collector(long genomeLength) {
        return GenomeStatistics.ngXCollector(genomeLength, 0.5);
    }

    public static <T extends Number> Collector<T, GenomeStatisticsBuilder, OptionalInt> ng90Collector(long genomeLength) {
        return GenomeStatistics.ngXCollector(genomeLength, 0.9);
    }

    public static <T extends Number> Collector<T, GenomeStatisticsBuilder, OptionalInt> ng75Collector(long genomeLength) {
        return GenomeStatistics.ngXCollector(genomeLength, 0.75);
    }

    public static <T extends Number> Collector<T, GenomeStatisticsBuilder, OptionalInt> ngXCollector(long genomeLength, double percentage) {
        return new NgXCollector(genomeLength, percentage);
    }

    public static <T extends Number> Collector<T, GenomeStatisticsBuilder, OptionalInt> n50Collector() {
        return GenomeStatistics.nXCollector(0.5);
    }

    public static <T extends Number> Collector<T, GenomeStatisticsBuilder, OptionalInt> n90Collector() {
        return GenomeStatistics.nXCollector(0.9);
    }

    public static <T extends Number> Collector<T, GenomeStatisticsBuilder, OptionalInt> n75Collector() {
        return GenomeStatistics.nXCollector(0.75);
    }

    public static <T extends Number> Collector<T, GenomeStatisticsBuilder, OptionalInt> nXCollector(double percentage) {
        return new NXCollector(percentage);
    }

    private static class NXCollector<T extends Number>
    implements Collector<T, GenomeStatisticsBuilder, OptionalInt> {
        private final double percentage;

        public NXCollector(double percentage) {
            this.percentage = percentage;
        }

        @Override
        public Supplier<GenomeStatisticsBuilder> supplier() {
            return () -> new NStatBuilder(this.percentage);
        }

        @Override
        public BiConsumer<GenomeStatisticsBuilder, T> accumulator() {
            return (builder, v) -> builder.add(v.longValue());
        }

        @Override
        public BinaryOperator<GenomeStatisticsBuilder> combiner() {
            return (a, b) -> a.merge((GenomeStatisticsBuilder)b);
        }

        @Override
        public Function<GenomeStatisticsBuilder, OptionalInt> finisher() {
            return GenomeStatisticsBuilder::build;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.singleton(Collector.Characteristics.UNORDERED);
        }
    }

    private static class NgXCollector<T extends Number>
    implements Collector<T, GenomeStatisticsBuilder, OptionalInt> {
        private final long genomeLength;
        private final double percentage;

        public NgXCollector(long genomeLength, double percentage) {
            if (genomeLength <= 0L) {
                throw new IllegalArgumentException("genome length must be > 0");
            }
            if (percentage <= 0.0) {
                throw new IllegalArgumentException("percentage must be > 0");
            }
            if (percentage >= 1.0) {
                throw new IllegalArgumentException("percentage must be < 1");
            }
            this.genomeLength = genomeLength;
            this.percentage = percentage;
        }

        @Override
        public Supplier<GenomeStatisticsBuilder> supplier() {
            return () -> new NGStatBuilder(this.genomeLength, this.percentage);
        }

        @Override
        public BiConsumer<GenomeStatisticsBuilder, T> accumulator() {
            return (builder, v) -> builder.add(v.longValue());
        }

        @Override
        public BinaryOperator<GenomeStatisticsBuilder> combiner() {
            return (a, b) -> a.merge((GenomeStatisticsBuilder)b);
        }

        @Override
        public Function<GenomeStatisticsBuilder, OptionalInt> finisher() {
            return GenomeStatisticsBuilder::build;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.singleton(Collector.Characteristics.UNORDERED);
        }
    }

    private static final class NGStatBuilder
    extends AbstractStatBuilder {
        private final long genomeLength;

        public NGStatBuilder(long genomeLength, double percentage) {
            super(percentage);
            if (genomeLength < 1L) {
                throw new IllegalArgumentException("genome length must be >= 1");
            }
            this.genomeLength = genomeLength;
        }

        @Override
        protected double computeDivisor(int[] sorted) {
            return this.genomeLength;
        }
    }

    private static final class NStatBuilder
    extends AbstractStatBuilder {
        public NStatBuilder(double percentage) {
            super(percentage);
        }

        @Override
        protected double computeDivisor(int[] sorted) {
            long sum = 0L;
            for (int i = 0; i < sorted.length; ++i) {
                sum += (long)sorted[i];
            }
            return sum;
        }
    }

    private static abstract class AbstractStatBuilder
    implements GenomeStatisticsBuilder {
        private final GrowableIntArray array = new GrowableIntArray();
        private final double percentage;

        public AbstractStatBuilder(double percentage) {
            this.percentage = percentage;
        }

        @Override
        public GenomeStatisticsBuilder add(int length) {
            if (length < 1) {
                throw new IllegalArgumentException("length can not be less than 1");
            }
            this.array.append(length);
            return this;
        }

        @Override
        public GenomeStatisticsBuilder merge(GenomeStatisticsBuilder other) {
            if (!(other instanceof AbstractStatBuilder)) {
                throw new IllegalStateException("can not merge builders of different types");
            }
            this.array.append(((AbstractStatBuilder)other).array);
            return this;
        }

        @Override
        public GenomeStatisticsBuilder add(long value) {
            if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
                throw new IllegalArgumentException("value must fit into an int : " + value);
            }
            return this.add((int)value);
        }

        @Override
        public OptionalInt build() {
            if (this.array.getCurrentLength() == 0) {
                return OptionalInt.empty();
            }
            this.array.sort();
            int[] sorted = this.array.toArray();
            double divisor = this.computeDivisor(sorted);
            long valueSoFar = 0L;
            for (int i = sorted.length - 1; i >= 0; --i) {
                int value = sorted[i];
                if (!((double)(valueSoFar += (long)value) / divisor >= this.percentage)) continue;
                return OptionalInt.of(value);
            }
            return OptionalInt.empty();
        }

        protected abstract double computeDivisor(int[] var1);
    }

    public static interface GenomeStatisticsBuilder {
        public GenomeStatisticsBuilder add(int var1);

        public GenomeStatisticsBuilder add(long var1);

        public GenomeStatisticsBuilder merge(GenomeStatisticsBuilder var1);

        public OptionalInt build();
    }
}

