/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.util;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.jcvi.jillion.core.util.Builder;
import org.jcvi.jillion.core.util.MultipleFileFilter;
import org.jcvi.jillion.core.util.iter.ArrayIterator;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.internal.core.util.FIFOQueue;
import org.jcvi.jillion.internal.core.util.LIFOQueue;

public abstract class FileIterator
implements Iterator<File>,
Iterable<File> {
    private static final FileFilter NON_DIRECTORY_FILTER = new NonDirectoryFileFilter();
    private static final FileFilter NON_HIDDEN_FILTER = new NonHiddenFileFilter();
    private static final FileFilter NULL_FILTER = new NullFileFilter();
    private static final FileNameComparator FILE_NAME_SORTER = new FileNameComparator();
    private Iterator<File> fileIterator;
    private final FileFilter fileFilter;
    private File nextFile;
    private final File rootDir;

    public static FileIteratorBuilder createDepthFirstFileIteratorBuilder(File rootDir) {
        return new DepthFirstFileIteratorBuilder(rootDir);
    }

    public static FileIteratorBuilder createBreadthFirstFileIteratorBuilder(File rootDir) {
        return new BreadthFirstFileIteratorBuilder(rootDir);
    }

    public static FileIteratorBuilder createNonRecursiveFileIteratorBuilder(File dir) {
        return new NonRecursiveFileIteratorBuilder(dir);
    }

    private FileIterator(File rootDir, FileFilter fileFilter) {
        if (rootDir == null) {
            throw new NullPointerException("rootDir can not be null");
        }
        if (!rootDir.isDirectory()) {
            throw new IllegalArgumentException("rootDir must be a directory");
        }
        if (fileFilter == null) {
            throw new NullPointerException("fileFilter can not be null");
        }
        this.fileFilter = fileFilter;
        this.rootDir = rootDir;
        this.setUpInitialState(rootDir);
    }

    protected void setUpInitialState(File rootDir) {
        this.updateFileIterator(rootDir);
        this.nextFile = this.getNextFile();
    }

    protected void updateFileIterator(File rootDir) {
        this.fileIterator = this.getFilesFor(rootDir);
    }

    private Iterator<File> getFilesFor(File dir) {
        File[] listFiles = dir.listFiles(this.fileFilter);
        if (listFiles == null) {
            return IteratorUtil.createEmptyIterator();
        }
        Arrays.sort(listFiles, FILE_NAME_SORTER);
        return new ArrayIterator<File>(listFiles, false);
    }

    @Override
    public Iterator<File> iterator() {
        return this.createNewInstance(this.rootDir, this.fileFilter);
    }

    protected abstract Iterator<File> createNewInstance(File var1, FileFilter var2);

    protected File getNextFile() {
        if (this.fileIterator.hasNext()) {
            return this.fileIterator.next();
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.nextFile != null;
    }

    @Override
    public File next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("no more files");
        }
        File fileToReturn = this.nextFile;
        this.nextFile = this.getNextFile();
        return fileToReturn;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("can not remove");
    }

    private static final class NonRecursiveFileIteratorBuilder
    extends FileIteratorBuilder {
        public NonRecursiveFileIteratorBuilder(File rootdir) {
            super(rootdir);
        }

        @Override
        protected FileIterator createFileIterator(File rootDir, FileFilter fileFilter) {
            return new NonRecursiveFileIterator(rootDir, fileFilter);
        }
    }

    private static final class DepthFirstFileIteratorBuilder
    extends FileIteratorBuilder {
        public DepthFirstFileIteratorBuilder(File rootdir) {
            super(rootdir);
        }

        @Override
        protected FileIterator createFileIterator(File rootDir, FileFilter fileFilter) {
            return new DepthFirstFileIterator(rootDir, fileFilter);
        }
    }

    private static final class BreadthFirstFileIteratorBuilder
    extends FileIteratorBuilder {
        public BreadthFirstFileIteratorBuilder(File rootdir) {
            super(rootdir);
        }

        @Override
        protected FileIterator createFileIterator(File rootDir, FileFilter fileFilter) {
            return new BreadthFirstFileIterator(rootDir, fileFilter);
        }
    }

    public static abstract class FileIteratorBuilder
    implements Builder<FileIterator> {
        private boolean includeDirectories = false;
        private boolean includeHiddenFiles = false;
        private FileFilter userDefinedFileFilter = null;
        private final File rootDir;

        public FileIteratorBuilder(File rootdir) {
            this.rootDir = rootdir;
        }

        public FileIteratorBuilder includeDirectories(boolean includeDirectories) {
            this.includeDirectories = includeDirectories;
            return this;
        }

        public FileIteratorBuilder includeHiddenFiles(boolean includeHiddenFiles) {
            this.includeHiddenFiles = includeHiddenFiles;
            return this;
        }

        public FileIteratorBuilder fileFilter(FileFilter fileFilter) {
            this.userDefinedFileFilter = fileFilter;
            return this;
        }

        protected abstract FileIterator createFileIterator(File var1, FileFilter var2);

        @Override
        public FileIterator build() {
            FileFilter fileFilter = this.includeHiddenFiles ? (this.includeDirectories ? NULL_FILTER : NON_DIRECTORY_FILTER) : (this.includeDirectories ? NON_HIDDEN_FILTER : new MultipleFileFilter(NON_DIRECTORY_FILTER, NON_HIDDEN_FILTER));
            if (this.userDefinedFileFilter != null) {
                fileFilter = new MultipleFileFilter(fileFilter, this.userDefinedFileFilter);
            }
            return this.createFileIterator(this.rootDir, fileFilter);
        }
    }

    private static class BreadthFirstFileIterator
    extends RecursiveFileIterator {
        public BreadthFirstFileIterator(File rootDir, FileFilter fileFilter) {
            super(rootDir, fileFilter);
        }

        @Override
        protected Queue<File> createDirectoryIterator() {
            return new FIFOQueue<File>();
        }

        @Override
        protected Iterator<File> createNewInstance(File root, FileFilter fileFilter) {
            return new BreadthFirstFileIterator(root, fileFilter);
        }
    }

    private static class DepthFirstFileIterator
    extends RecursiveFileIterator {
        public DepthFirstFileIterator(File rootDir, FileFilter fileFilter) {
            super(rootDir, fileFilter);
        }

        @Override
        protected Queue<File> createDirectoryIterator() {
            return new LIFOQueue<File>();
        }

        @Override
        protected Iterator<File> createNewInstance(File root, FileFilter fileFilter) {
            return new DepthFirstFileIterator(root, fileFilter);
        }
    }

    private static abstract class RecursiveFileIterator
    extends FileIterator {
        private static final DirectoryFileFilter DIRECTORY_FILTER = new DirectoryFileFilter();
        private Queue<File> dirIterator;

        protected RecursiveFileIterator(File rootDir, FileFilter fileFilter) {
            super(rootDir, fileFilter);
        }

        protected abstract Queue<File> createDirectoryIterator();

        private List<File> getSubdirectoriesFor(File dir) {
            File[] listFiles = dir.listFiles(DIRECTORY_FILTER);
            if (listFiles == null) {
                return Collections.emptyList();
            }
            Arrays.sort(listFiles, FILE_NAME_SORTER);
            return Arrays.asList(listFiles);
        }

        @Override
        protected void setUpInitialState(File rootDir) {
            this.dirIterator = this.createDirectoryIterator();
            this.dirIterator.addAll(this.getSubdirectoriesFor(rootDir));
            super.setUpInitialState(rootDir);
        }

        @Override
        protected File getNextFile() {
            File nextFile = super.getNextFile();
            if (nextFile == null && this.hasMoreSubDirs()) {
                return this.getNextFromSubDir();
            }
            return nextFile;
        }

        private boolean hasMoreSubDirs() {
            return !this.dirIterator.isEmpty();
        }

        private File getNextFromSubDir() {
            File newDir = this.dirIterator.poll();
            this.updateFileIterator(newDir);
            this.dirIterator.addAll(this.getSubdirectoriesFor(newDir));
            return this.getNextFile();
        }

        private static final class DirectoryFileFilter
        implements FileFilter {
            private DirectoryFileFilter() {
            }

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        }
    }

    private static class NonRecursiveFileIterator
    extends FileIterator {
        protected NonRecursiveFileIterator(File rootDir, FileFilter fileFilter) {
            super(rootDir, fileFilter);
        }

        @Override
        protected Iterator<File> createNewInstance(File root, FileFilter fileFilter) {
            return new NonRecursiveFileIterator(root, fileFilter);
        }
    }

    private static final class NullFileFilter
    implements FileFilter {
        private NullFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return true;
        }
    }

    private static final class NonHiddenFileFilter
    implements FileFilter {
        private NonHiddenFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return !file.isHidden();
        }
    }

    private static final class NonDirectoryFileFilter
    implements FileFilter {
        private NonDirectoryFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return !file.isDirectory();
        }
    }

    private static final class FileNameComparator
    implements Comparator<File>,
    Serializable {
        private static final long serialVersionUID = 4585888483429023724L;

        private FileNameComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

