/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.util;

import java.util.Date;

public final class DateUtil {
    private static final long SECONDS = 1000L;
    private static final long MINS = 60000L;
    private static final long HOURS = 3600000L;
    private static final long DAYS = 86400000L;
    private static long SPECIFIED_TIME;
    private static boolean USE_SYSTEM_TIME;

    private DateUtil() {
    }

    public static synchronized Date getCurrentDate() {
        if (USE_SYSTEM_TIME) {
            return new Date();
        }
        return new Date(SPECIFIED_TIME);
    }

    public static synchronized void setCurrentDate(Date date) {
        if (date == null) {
            throw new NullPointerException("specified date can not be null");
        }
        USE_SYSTEM_TIME = false;
        SPECIFIED_TIME = date.getTime();
    }

    public static synchronized void restoreDate() {
        USE_SYSTEM_TIME = true;
    }

    public static String getElapsedTimeAsString(long numberOfMillis) {
        long numSeconds;
        long numMins;
        long numHours;
        if (numberOfMillis < 1000L) {
            return "P0S";
        }
        StringBuilder builder = new StringBuilder("P");
        long millisLeft = numberOfMillis;
        long numDays = millisLeft / 86400000L;
        if (numDays > 0L) {
            builder.append(numDays).append('D');
            millisLeft -= numDays * 86400000L;
        }
        if ((numHours = millisLeft / 3600000L) > 0L) {
            builder.append(numHours).append('H');
            millisLeft -= numHours * 3600000L;
        }
        if ((numMins = millisLeft / 60000L) > 0L) {
            builder.append(numMins).append('M');
            millisLeft -= numMins * 60000L;
        }
        if ((numSeconds = millisLeft / 1000L) > 0L) {
            builder.append(numSeconds).append('S');
            millisLeft -= numSeconds * 1000L;
        }
        return builder.toString();
    }

    static {
        USE_SYSTEM_TIME = true;
    }
}

