/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.residue.nt;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.nt.AbstractNucleotideCodec;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.internal.core.util.GrowableIntArray;

final class UandTNucleotideCodec
extends AbstractNucleotideCodec {
    public static final UandTNucleotideCodec INSTANCE = new UandTNucleotideCodec();

    private UandTNucleotideCodec() {
        super(Nucleotide.Gap);
    }

    @Override
    protected int getNucleotidesPerGroup() {
        return 1;
    }

    @Override
    protected Nucleotide getNucleotide(byte encodedByte, int index) {
        return this.getGlyphFor(encodedByte);
    }

    @Override
    protected byte getByteFor(Nucleotide nuc) {
        return nuc.getOrdinalAsByte();
    }

    @Override
    protected Nucleotide getGlyphFor(byte b) {
        return Nucleotide.getByOrdinal(b);
    }

    @Override
    protected void encodeCompleteGroup(Iterator<Nucleotide> glyphs, ByteBuffer result, int offset) {
        result.put(this.getByteFor(glyphs.next()));
    }

    @Override
    protected void encodeLastGroup(Iterator<Nucleotide> glyphs, ByteBuffer result, int offset) {
        result.put(glyphs.hasNext() ? this.getByteFor(glyphs.next()) : (byte)0);
    }

    @Override
    public List<Range> getNRanges(byte[] encodedData) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        Iterator<Nucleotide> iter = this.iterator(encodedData);
        int offset = 0;
        Range.Builder currentBuilder = null;
        while (iter.hasNext()) {
            Nucleotide n = iter.next();
            if (n == Nucleotide.Unknown) {
                if (currentBuilder == null) {
                    currentBuilder = new Range.Builder(1L).shift(offset);
                } else if (currentBuilder.getEnd() == (long)(offset - 1)) {
                    currentBuilder.expandEnd(1L);
                } else {
                    ranges.add(currentBuilder.build());
                    currentBuilder = new Range.Builder(1L).shift(offset);
                }
            }
            ++offset;
        }
        if (currentBuilder != null) {
            ranges.add(currentBuilder.build());
        }
        return ranges;
    }

    @Override
    public List<Integer> getGapOffsets(byte[] encodedData) {
        GrowableIntArray array = this.getSentinelOffsets(encodedData);
        return array.toBoxedList();
    }
}

