/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.residue.nt;

import org.jcvi.jillion.core.residue.nt.Nucleotide;

public final class Triplet {
    private final byte first;
    private final byte second;
    private final byte third;
    private static final Triplet[][][] CACHE = new Triplet[16][16][16];

    public static Triplet create(char first, char second, char third) {
        return Triplet.create(Nucleotide.parse(first), Nucleotide.parse(second), Nucleotide.parse(third));
    }

    public static Triplet create(Nucleotide first, Nucleotide second, Nucleotide third) {
        Triplet newTriplet;
        int o3;
        int o2;
        int o1 = first.ordinal();
        Triplet fromCache = CACHE[o1][o2 = second.ordinal()][o3 = third.ordinal()];
        if (fromCache != null) {
            return fromCache;
        }
        Triplet.CACHE[o1][o2][o3] = newTriplet = new Triplet(o1, o2, o3);
        return newTriplet;
    }

    static void clearCache() {
        for (int i = 0; i < CACHE.length; ++i) {
            for (int j = 0; j < CACHE[i].length; ++j) {
                for (int k = 0; k < CACHE[i][j].length; ++k) {
                    Triplet.CACHE[i][j][k] = null;
                }
            }
        }
    }

    private Triplet(int first, int second, int third) {
        this.first = (byte)first;
        this.second = (byte)second;
        this.third = (byte)third;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.first;
        result = 31 * result + this.second;
        result = 31 * result + this.third;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Triplet)) {
            return false;
        }
        Triplet other = (Triplet)obj;
        if (this.first != other.first) {
            return false;
        }
        if (this.second != other.second) {
            return false;
        }
        return this.third == other.third;
    }

    public String toString() {
        return new StringBuilder(3).append(Nucleotide.getDnaValues().get(this.first)).append(Nucleotide.getDnaValues().get(this.second)).append(Nucleotide.getDnaValues().get(this.third)).toString();
    }

    public Nucleotide getFirst() {
        return Nucleotide.getDnaValues().get(this.first);
    }

    public Nucleotide getSecond() {
        return Nucleotide.getDnaValues().get(this.second);
    }

    public Nucleotide getThrid() {
        return Nucleotide.getDnaValues().get(this.third);
    }
}

