/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.residue.nt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;

public final class NucleotideSequencePermuter {
    private NucleotideSequencePermuter() {
    }

    public static Set<NucleotideSequence> permuteAmbiguities(NucleotideSequence seq) {
        NucleotideSequenceBuilder seqBuilder = new NucleotideSequenceBuilder(seq);
        int numAmbiguties = seqBuilder.getNumAmbiguities();
        if (numAmbiguties == 0) {
            return Collections.singleton(seq);
        }
        boolean convertTsToUs = seq.isRna();
        List<NucleotideSequenceBuilder> permutations = new ArrayList<NucleotideSequenceBuilder>();
        permutations.add(seqBuilder);
        int i = 0;
        while ((long)i < seqBuilder.getLength()) {
            if (seqBuilder.get(i).isAmbiguity()) {
                permutations = NucleotideSequencePermuter.permute(permutations, i, convertTsToUs);
            }
            ++i;
        }
        HashSet<NucleotideSequence> set = new HashSet<NucleotideSequence>(permutations.size());
        for (NucleotideSequenceBuilder builder : permutations) {
            set.add(builder.build());
        }
        return set;
    }

    private static List<NucleotideSequenceBuilder> permute(List<NucleotideSequenceBuilder> permutations, int offset, boolean convertTsToUs) {
        ArrayList<NucleotideSequenceBuilder> newPermutations = new ArrayList<NucleotideSequenceBuilder>(permutations.size() * 4);
        for (NucleotideSequenceBuilder builder : permutations) {
            Nucleotide ambiguity = builder.get(offset);
            for (Nucleotide n : ambiguity.getBasesFor()) {
                if (convertTsToUs && n == Nucleotide.Thymine) {
                    n = Nucleotide.Uracil;
                }
                newPermutations.add(builder.copy().replace(offset, n));
            }
        }
        return newPermutations;
    }

    public static Set<NucleotideSequence> permuteAmbiguities(Iterable<NucleotideSequence> sequences) {
        LinkedHashSet<NucleotideSequence> set = new LinkedHashSet<NucleotideSequence>();
        for (NucleotideSequence seq : sequences) {
            set.addAll(NucleotideSequencePermuter.permuteAmbiguities(seq));
        }
        return set;
    }
}

