/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.residue.nt;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.ResidueSequenceBuilder;
import org.jcvi.jillion.core.residue.nt.AcgtGapNucleotideCodec;
import org.jcvi.jillion.core.residue.nt.AcgtnNucloetideCodec;
import org.jcvi.jillion.core.residue.nt.BasicNucleotideCodec;
import org.jcvi.jillion.core.residue.nt.DefaultNucleotideSequence;
import org.jcvi.jillion.core.residue.nt.DefaultReferenceEncodedNucleotideSequence;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.ReferenceMappedNucleotideSequence;
import org.jcvi.jillion.core.residue.nt.UandTNucleotideCodec;
import org.jcvi.jillion.core.util.SingleThreadAdder;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.core.util.iter.PeekableIterator;
import org.jcvi.jillion.internal.core.util.GrowableByteArray;
import org.jcvi.jillion.internal.core.util.GrowableIntArray;

public final class NucleotideSequenceBuilder
implements ResidueSequenceBuilder<Nucleotide, NucleotideSequence> {
    private static final int INTITAL_BUFFER_SIZE = 200;
    private static final String NULL_SEQUENCE_ERROR_MSG = "sequence can not be null";
    private static final byte GAP_VALUE = Nucleotide.Gap.getOrdinalAsByte();
    private static final byte N_VALUE = Nucleotide.Unknown.getOrdinalAsByte();
    private static final byte A_VALUE = Nucleotide.Adenine.getOrdinalAsByte();
    private static final byte C_VALUE = Nucleotide.Cytosine.getOrdinalAsByte();
    private static final byte G_VALUE = Nucleotide.Guanine.getOrdinalAsByte();
    private static final byte T_VALUE = Nucleotide.Thymine.getOrdinalAsByte();
    private GrowableByteArray data;
    private CodecDecider codecDecider;

    public NucleotideSequenceBuilder() {
        this(200);
    }

    public NucleotideSequenceBuilder clear() {
        this.data.clear();
        this.codecDecider.clear();
        return this;
    }

    public NucleotideSequenceBuilder(int initialCapacity) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("initial capacity must be >=1");
        }
        this.data = new GrowableByteArray(initialCapacity);
        this.codecDecider = new CodecDecider();
    }

    public NucleotideSequenceBuilder(NucleotideSequence sequence) {
        this.assertNotNull(sequence);
        NewValues newValues = new NewValues(sequence);
        this.data = newValues.getData();
        this.codecDecider = new CodecDecider(newValues);
    }

    public NucleotideSequenceBuilder(Iterable<Nucleotide> sequence) {
        this.assertNotNull(sequence);
        NewValues newValues = new NewValues(sequence);
        this.data = newValues.getData();
        this.codecDecider = new CodecDecider(newValues);
    }

    public NucleotideSequenceBuilder(String sequence) {
        if (sequence == null) {
            throw new NullPointerException(NULL_SEQUENCE_ERROR_MSG);
        }
        NewValues newValues = new NewValues(sequence);
        this.data = newValues.getData();
        this.codecDecider = new CodecDecider(newValues);
    }

    public NucleotideSequenceBuilder(char[] sequence) {
        if (sequence == null) {
            throw new NullPointerException(NULL_SEQUENCE_ERROR_MSG);
        }
        NewValues newValues = new NewValues(sequence);
        this.data = newValues.getData();
        this.codecDecider = new CodecDecider(newValues);
    }

    public NucleotideSequenceBuilder(Nucleotide singleNucleotide) {
        if (singleNucleotide == null) {
            throw new NullPointerException("singleNucleotide can not be null");
        }
        NewValues newValues = new NewValues(singleNucleotide);
        this.data = newValues.getData();
        this.codecDecider = new CodecDecider(newValues);
    }

    private NucleotideSequenceBuilder(NucleotideSequenceBuilder copy) {
        this.data = copy.data.copy();
        this.codecDecider = copy.codecDecider.copy();
    }

    private NucleotideSequenceBuilder(GrowableByteArray data) {
        this.data = data;
        NewValues newValues = new NewValues(data);
        this.codecDecider = new CodecDecider(newValues);
    }

    public NucleotideSequenceBuilder(NucleotideSequence seq, Range range) {
        NewValues newValues = new NewValues(seq.iterator(range));
        this.data = newValues.getData();
        this.codecDecider = new CodecDecider(newValues);
    }

    public NucleotideSequenceBuilder append(Nucleotide base) {
        if (base == null) {
            throw new NullPointerException("base can not be null");
        }
        return this.append(Collections.singleton(base));
    }

    public NucleotideSequenceBuilder append(Iterable<Nucleotide> sequence) {
        this.assertNotNull(sequence);
        NewValues newValues = new NewValues(sequence);
        return this.append(newValues);
    }

    public NucleotideSequenceBuilder append(NucleotideSequence sequence) {
        this.assertNotNull(sequence);
        NewValues newValues = new NewValues(sequence);
        return this.append(newValues);
    }

    private NucleotideSequenceBuilder append(NewValues newValues) {
        this.data.append(newValues.data);
        this.codecDecider.append(newValues);
        return this;
    }

    public NucleotideSequenceBuilder append(NucleotideSequenceBuilder otherBuilder) {
        this.assertNotNull(otherBuilder);
        this.data.append(otherBuilder.data);
        this.codecDecider.append(otherBuilder);
        return this;
    }

    public NucleotideSequenceBuilder append(String sequence) {
        if (sequence == null) {
            throw new NullPointerException(NULL_SEQUENCE_ERROR_MSG);
        }
        return this.append(new NewValues(sequence));
    }

    public NucleotideSequenceBuilder append(char[] sequence) {
        if (sequence == null) {
            throw new NullPointerException(NULL_SEQUENCE_ERROR_MSG);
        }
        return this.append(new NewValues(sequence));
    }

    public NucleotideSequenceBuilder append(Nucleotide[] sequence) {
        if (sequence == null) {
            throw new NullPointerException(NULL_SEQUENCE_ERROR_MSG);
        }
        return this.append(new NewValues(sequence));
    }

    public NucleotideSequenceBuilder insert(int offset, String sequence) {
        this.assertInsertionParametersValid(offset, sequence);
        return this.insert(offset, new NewValues(sequence));
    }

    public NucleotideSequenceBuilder insert(int offset, char[] sequence) {
        this.assertInsertionParametersValid(offset, sequence);
        return this.insert(offset, new NewValues(sequence));
    }

    public NucleotideSequenceBuilder replace(Range gappedRangeToBeReplaced, NucleotideSequenceBuilder replacementSeq) {
        this.delete(gappedRangeToBeReplaced);
        this.insert((int)gappedRangeToBeReplaced.getBegin(), (ResidueSequenceBuilder)replacementSeq);
        return this;
    }

    public NucleotideSequenceBuilder replace(Range gappedRangeToBeReplaced, char[] replacementSeq) {
        this.delete(gappedRangeToBeReplaced);
        this.insert((int)gappedRangeToBeReplaced.getBegin(), replacementSeq);
        return this;
    }

    public NucleotideSequenceBuilder replace(Range gappedRangeToBeReplaced, String replacementSeq) {
        this.delete(gappedRangeToBeReplaced);
        this.insert((int)gappedRangeToBeReplaced.getBegin(), replacementSeq);
        return this;
    }

    public NucleotideSequenceBuilder replace(Range gappedRangeToBeReplaced, NucleotideSequence replacementSeq) {
        this.delete(gappedRangeToBeReplaced);
        this.insert((int)gappedRangeToBeReplaced.getBegin(), replacementSeq);
        return this;
    }

    private void assertNotNull(Object sequence) {
        if (sequence == null) {
            throw new NullPointerException(NULL_SEQUENCE_ERROR_MSG);
        }
    }

    @Override
    public long getLength() {
        return this.codecDecider.getCurrentLength();
    }

    @Override
    public long getUngappedLength() {
        return this.codecDecider.getCurrentLength() - this.codecDecider.getNumberOfGaps();
    }

    public NucleotideSequenceBuilder replace(int offset, Nucleotide replacement) {
        if (offset < 0 || offset >= this.data.getCurrentLength()) {
            throw new IllegalArgumentException(String.format("offset %d out of range (length = %d)", this.data.getCurrentLength(), offset));
        }
        if (replacement == null) {
            throw new NullPointerException("replacement base can not be null");
        }
        return this.privateReplace(offset, replacement);
    }

    private NucleotideSequenceBuilder privateReplace(int offset, Nucleotide replacement) {
        byte value = (byte)replacement.ordinal();
        byte oldValue = this.data.get(offset);
        this.codecDecider.replace(offset, oldValue, value);
        this.data.replace(offset, value);
        return this;
    }

    @Override
    public NucleotideSequenceBuilder delete(Range range) {
        if (range == null) {
            throw new NullPointerException("range can not be null");
        }
        if (!range.isEmpty()) {
            Range rangeToDelete = Range.of(Math.max(0L, range.getBegin()), Math.min((long)(this.data.getCurrentLength() - 1), range.getEnd()));
            GrowableByteArray deletedBytes = this.data.subArray(rangeToDelete);
            NewValues newValues = new NewValues(deletedBytes);
            this.codecDecider.delete((int)range.getBegin(), newValues);
            this.data.remove(rangeToDelete);
        }
        return this;
    }

    @Override
    public Nucleotide get(int offset) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("offset can not have negatives coordinates: " + offset);
        }
        if ((long)offset > this.getLength()) {
            throw new IndexOutOfBoundsException(String.format("offset can not start beyond current length (%d) : %d", this.getLength(), offset));
        }
        return Nucleotide.getByOrdinal(this.data.get(offset));
    }

    @Override
    public int getNumGaps() {
        return this.codecDecider.getNumberOfGaps();
    }

    public int[] getGapOffsets() {
        return this.codecDecider.gapOffsets.toArray();
    }

    int[] getNOffsets() {
        return this.codecDecider.nOffsets.toArray();
    }

    public int getNumNs() {
        return this.codecDecider.getNumberOfNs();
    }

    public int getNumAmbiguities() {
        return this.codecDecider.getNumberOfAmbiguities();
    }

    public NucleotideSequenceBuilder prepend(String sequence) {
        return this.insert(0, sequence);
    }

    public NucleotideSequenceBuilder prepend(char[] sequence) {
        return this.insert(0, sequence);
    }

    public NucleotideSequenceBuilder insert(int offset, Iterable<Nucleotide> sequence) {
        this.assertInsertionParametersValid(offset, sequence);
        NewValues newValues = new NewValues(sequence);
        return this.insert(offset, newValues);
    }

    public NucleotideSequenceBuilder insert(int offset, Nucleotide[] sequence) {
        this.assertInsertionParametersValid(offset, sequence);
        NewValues newValues = new NewValues(sequence);
        return this.insert(offset, newValues);
    }

    public NucleotideSequenceBuilder insert(int offset, NucleotideSequence sequence) {
        this.assertInsertionParametersValid(offset, sequence);
        NewValues newValues = new NewValues(sequence);
        return this.insert(offset, newValues);
    }

    private void assertInsertionParametersValid(int offset, Object sequence) {
        this.assertNotNull(sequence);
        if (offset < 0) {
            throw new IllegalArgumentException("offset can not have negatives coordinates: " + offset);
        }
        if ((long)offset > this.getLength()) {
            throw new IllegalArgumentException(String.format("offset can not start beyond current length (%d) : %d", this.getLength(), offset));
        }
    }

    private NucleotideSequenceBuilder insert(int offset, NewValues newValues) {
        this.data.insert(offset, newValues.data);
        this.codecDecider.insert(offset, newValues);
        return this;
    }

    public NucleotideSequenceBuilder insert(int offset, ResidueSequenceBuilder<Nucleotide, NucleotideSequence> otherBuilder) {
        this.assertNotNull(otherBuilder);
        if (!(otherBuilder instanceof NucleotideSequenceBuilder)) {
            throw new IllegalArgumentException("otherBuilder must be a NucleotideSequenceBuilder");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset can not have negatives coordinates: " + offset);
        }
        if ((long)offset > this.getLength()) {
            throw new IllegalArgumentException(String.format("offset can not start beyond current length (%d) : %d", this.getLength(), offset));
        }
        NucleotideSequenceBuilder otherSequenceBuilder = (NucleotideSequenceBuilder)otherBuilder;
        NewValues newValues = new NewValues(otherSequenceBuilder);
        if ((long)offset == this.getLength()) {
            return this.append(newValues);
        }
        return this.insert(offset, newValues);
    }

    public NucleotideSequenceBuilder insert(int offset, Nucleotide base) {
        if (base == null) {
            throw new NullPointerException("base can not be null");
        }
        return this.insert(offset, Collections.singleton(base));
    }

    public NucleotideSequenceBuilder prepend(Iterable<Nucleotide> sequence) {
        return this.insert(0, (Iterable)sequence);
    }

    public NucleotideSequenceBuilder prepend(NucleotideSequence sequence) {
        return this.insert(0, sequence);
    }

    public NucleotideSequenceBuilder prepend(ResidueSequenceBuilder<Nucleotide, NucleotideSequence> otherBuilder) {
        return this.insert(0, (ResidueSequenceBuilder)otherBuilder);
    }

    @Override
    public NucleotideSequence build() {
        if (this.codecDecider.numUs > 0 && this.codecDecider.numTs > 0) {
            byte[] encodedBytes = UandTNucleotideCodec.INSTANCE.encode(this.codecDecider.currentLength, this.codecDecider.gapOffsets.toArray(), this.iterator(false));
            return new DefaultNucleotideSequence(UandTNucleotideCodec.INSTANCE, encodedBytes, true, false);
        }
        if (this.codecDecider.hasAlignedReference()) {
            return new DefaultReferenceEncodedNucleotideSequence(this.codecDecider.alignedReference.reference, this, this.codecDecider.alignedReference.offset);
        }
        boolean convertUs2Ts = this.codecDecider.numUs <= 0 || this.codecDecider.numTs <= 0;
        return this.codecDecider.encode(this.iterator(convertUs2Ts));
    }

    public NucleotideSequenceBuilder convertToDna() {
        if (this.codecDecider.numUs == 0) {
            return this;
        }
        CodecDecider codecDecider = this.codecDecider;
        codecDecider.numTs = codecDecider.numTs + this.codecDecider.numUs;
        this.codecDecider.numUs = 0;
        this.data.forEachIndexed((i, v) -> {
            if (v == Nucleotide.Uracil.getOrdinalAsByte()) {
                this.data.replace(i, Nucleotide.Thymine.getOrdinalAsByte());
            }
        });
        return this;
    }

    public NucleotideSequenceBuilder convertToRna() {
        if (this.codecDecider.numTs == 0) {
            return this;
        }
        CodecDecider codecDecider = this.codecDecider;
        codecDecider.numUs = codecDecider.numUs + this.codecDecider.numTs;
        this.codecDecider.numTs = 0;
        this.data.forEachIndexed((i, v) -> {
            if (v == Nucleotide.Thymine.getOrdinalAsByte()) {
                this.data.replace(i, Nucleotide.Uracil.getOrdinalAsByte());
            }
        });
        return this;
    }

    private Iterator<Nucleotide> iterator(boolean convertRnaToDna) {
        if (convertRnaToDna) {
            return new Iterator<Nucleotide>(){
                int currentOffset = 0;
                int length = NucleotideSequenceBuilder.access$900(NucleotideSequenceBuilder.this).getCurrentLength();

                @Override
                public boolean hasNext() {
                    return this.currentOffset < this.length;
                }

                @Override
                public Nucleotide next() {
                    Nucleotide n = Nucleotide.getByOrdinal(NucleotideSequenceBuilder.this.data.get(this.currentOffset++));
                    if (Nucleotide.Uracil == n) {
                        return Nucleotide.Thymine;
                    }
                    return n;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<Nucleotide>(){
            int currentOffset = 0;
            int length = NucleotideSequenceBuilder.access$900(NucleotideSequenceBuilder.this).getCurrentLength();

            @Override
            public boolean hasNext() {
                return this.currentOffset < this.length;
            }

            @Override
            public Nucleotide next() {
                return Nucleotide.getByOrdinal(NucleotideSequenceBuilder.this.data.get(this.currentOffset++));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<Nucleotide> iterator() {
        return this.iterator(false);
    }

    public ReferenceMappedNucleotideSequence buildReferenceEncodedNucleotideSequence() {
        if (!this.codecDecider.hasAlignedReference()) {
            throw new IllegalStateException("must provide reference");
        }
        return (ReferenceMappedNucleotideSequence)this.build();
    }

    public NucleotideSequenceBuilder setReferenceHint(NucleotideSequence referenceSequence, int gappedStartOffset) {
        this.codecDecider.alignedReference(new AlignedReference(referenceSequence, gappedStartOffset));
        return this;
    }

    @Override
    public NucleotideSequenceBuilder trim(Range range) {
        if (range.getEnd() < 0L || range.isEmpty()) {
            return this.delete(Range.ofLength(this.getLength()));
        }
        Range trimRange = range.intersection(Range.ofLength(this.getLength()));
        NucleotideSequenceBuilder builder = new NucleotideSequenceBuilder(this.data.subArray(trimRange));
        if (this.codecDecider.hasAlignedReference()) {
            builder.setReferenceHint(this.codecDecider.alignedReference.reference, this.codecDecider.alignedReference.offset + (int)range.getBegin());
        }
        this.codecDecider = builder.codecDecider;
        this.data = builder.data;
        return this;
    }

    @Override
    public NucleotideSequenceBuilder copy() {
        return new NucleotideSequenceBuilder(this);
    }

    public NucleotideSequenceBuilder copy(Range gappedRange) {
        return new NucleotideSequenceBuilder(this.data.subArray(gappedRange));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data.toArray());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NucleotideSequenceBuilder)) {
            return false;
        }
        NucleotideSequenceBuilder other = (NucleotideSequenceBuilder)obj;
        return Arrays.equals(this.data.toArray(), other.data.toArray());
    }

    public boolean isEqualTo(NucleotideSequence other) {
        if (other == null) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        Iterator<Nucleotide> iter = this.iterator(false);
        Iterator otherIter = other.iterator();
        while (iter.hasNext()) {
            if (iter.next().equals(otherIter.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEqualToIgnoringGaps(NucleotideSequence other) {
        if (other == null) {
            return false;
        }
        if (this.getUngappedLength() != other.getUngappedLength()) {
            return false;
        }
        Iterator<Nucleotide> iter = this.iterator(false);
        Iterator<Nucleotide> otherIter = other.iterator();
        while (iter.hasNext()) {
            Nucleotide nextOtherNonGap;
            Nucleotide nextNonGap = this.getNextNonGapBaseFrom(iter);
            if (nextNonGap == null || nextNonGap.equals(nextOtherNonGap = this.getNextNonGapBaseFrom(otherIter))) continue;
            return false;
        }
        return true;
    }

    private Nucleotide getNextNonGapBaseFrom(Iterator<Nucleotide> iter) {
        Nucleotide nextNonGap;
        while ((nextNonGap = iter.next()).isGap() && iter.hasNext()) {
        }
        if (nextNonGap.isGap()) {
            return null;
        }
        return nextNonGap;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(this.codecDecider.getCurrentLength());
        Iterator<Nucleotide> iter = this.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
        }
        return builder.toString();
    }

    public NucleotideSequenceBuilder reverseComplement() {
        byte[] bytes = this.data.toArray();
        int currentLength = bytes.length;
        int pivotOffset = currentLength / 2;
        for (int i = 0; i < pivotOffset; ++i) {
            byte complementOrdinal;
            int compOffset = currentLength - 1 - i;
            Nucleotide tmp = Nucleotide.getDnaValues().get(bytes[i]).complement();
            bytes[i] = complementOrdinal = Nucleotide.getDnaValues().get(bytes[compOffset]).complement().getOrdinalAsByte();
            bytes[compOffset] = tmp.getOrdinalAsByte();
        }
        if (currentLength % 2 != 0) {
            bytes[pivotOffset] = Nucleotide.getDnaValues().get(bytes[pivotOffset]).complement().getOrdinalAsByte();
        }
        this.data = new GrowableByteArray(bytes);
        this.codecDecider.reverse();
        return this;
    }

    public NucleotideSequenceBuilder complement() {
        int currentLength = this.codecDecider.getCurrentLength();
        byte[] complementedData = new byte[currentLength];
        byte[] originalData = this.data.toArray();
        for (int i = 0; i < originalData.length; ++i) {
            complementedData[i] = Nucleotide.getDnaValues().get(originalData[i]).complement().getOrdinalAsByte();
        }
        this.data = new GrowableByteArray(complementedData);
        return this;
    }

    public NucleotideSequenceBuilder turnOffDataCompression(boolean turnOffDataCompression) {
        this.codecDecider.forceBasicCompression(turnOffDataCompression);
        return this;
    }

    @Override
    public NucleotideSequenceBuilder reverse() {
        this.data.reverse();
        this.codecDecider.reverse();
        return this;
    }

    public NucleotideSequenceBuilder ungap() {
        int numGaps = this.codecDecider.getNumberOfGaps();
        if (numGaps == 0) {
            return this;
        }
        byte[] oldBytes = this.data.toArray();
        byte[] newBytes = new byte[oldBytes.length - this.codecDecider.gapOffsets.getCurrentLength()];
        Iterator<Integer> gapIterator = this.codecDecider.gapOffsets.iterator();
        int oldOffset = 0;
        int newOffset = 0;
        while (gapIterator.hasNext()) {
            int nextGapOffset = gapIterator.next();
            while (oldOffset < nextGapOffset) {
                newBytes[newOffset] = oldBytes[oldOffset];
                ++oldOffset;
                ++newOffset;
            }
            ++oldOffset;
        }
        while (oldOffset < oldBytes.length) {
            newBytes[newOffset] = oldBytes[oldOffset];
            ++oldOffset;
            ++newOffset;
        }
        this.data = new GrowableByteArray(newBytes);
        this.codecDecider.ungap();
        return this;
    }

    public Range toGappedRange(Range ungappedRange) {
        int ungappedStart = (int)ungappedRange.getBegin();
        int ungappedEnd = (int)ungappedRange.getEnd();
        return Range.of(this.getGappedOffsetFor(ungappedStart), (long)this.getGappedOffsetFor(ungappedEnd));
    }

    public Range toUngappedRange(Range gappedRange) {
        Objects.requireNonNull(gappedRange);
        long gappedBegin = gappedRange.getBegin();
        long gappedEnd = gappedRange.getEnd();
        long currentLength = this.codecDecider.getCurrentLength();
        if (gappedBegin >= currentLength || gappedEnd >= currentLength) {
            throw new IndexOutOfBoundsException("gapped Range of " + gappedRange + " is beyond the gapped sequence length of " + currentLength);
        }
        GrowableIntArray gaps = this.codecDecider.gapOffsets;
        if (gaps.getCurrentLength() == 0) {
            return gappedRange;
        }
        long ungappedStart = gappedBegin - (long)this.numGapsUntil(gaps, (int)gappedBegin);
        long ungappedEnd = gappedEnd - (long)this.numGapsUntil(gaps, (int)gappedEnd);
        return Range.of(ungappedStart, ungappedEnd);
    }

    private int numGapsUntil(GrowableIntArray gaps, int gappedOffset) {
        int insertionPoint = gaps.binarySearch(gappedOffset);
        if (insertionPoint >= 0) {
            return insertionPoint + 1;
        }
        return -insertionPoint - 1;
    }

    public int getGappedOffsetFor(int ungappedOffset) {
        SingleThreadAdder currentOffset = new SingleThreadAdder(ungappedOffset);
        this.codecDecider.gapOffsets.stream().forEach((int i) -> {
            if (i <= currentOffset.intValue()) {
                currentOffset.increment();
            }
        });
        return currentOffset.intValue();
    }

    public int getNumUs() {
        return this.codecDecider.numUs;
    }

    private static class NewValues {
        private final GrowableByteArray data;
        private int numberOfACGTs;
        private int numUs;
        private int numTs;
        private final GrowableIntArray nOffsets;
        private final GrowableIntArray gapOffsets;

        public NewValues(GrowableByteArray data) {
            this.data = data.copy();
            this.nOffsets = new GrowableIntArray(12);
            this.gapOffsets = new GrowableIntArray(12);
            SingleThreadAdder offset = new SingleThreadAdder();
            data.stream().forEach(i -> {
                this.handleOrdinal((byte)i, offset.intValue());
                offset.increment();
            });
        }

        public NewValues(Nucleotide nucleotide) {
            this.nOffsets = new GrowableIntArray(12);
            this.gapOffsets = new GrowableIntArray(12);
            this.data = new GrowableByteArray(1);
            this.handle(nucleotide, 0);
        }

        public NewValues(Nucleotide[] sequence) {
            this.nOffsets = new GrowableIntArray();
            this.gapOffsets = new GrowableIntArray();
            this.data = new GrowableByteArray(sequence.length);
            int offset = 0;
            for (int i = 0; i < sequence.length; ++i) {
                Nucleotide n = sequence[i];
                if (n == null) continue;
                this.handle(n, offset);
                ++offset;
            }
        }

        public NewValues(String sequence) {
            this.nOffsets = new GrowableIntArray(12);
            this.gapOffsets = new GrowableIntArray(12);
            this.data = new GrowableByteArray(sequence.length());
            int offset = 0;
            char[] chars = sequence.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                Nucleotide n = Nucleotide.parseOrNull(c);
                if (n == null) continue;
                this.handle(n, offset);
                ++offset;
            }
        }

        public NewValues(char[] sequence) {
            this.nOffsets = new GrowableIntArray(12);
            this.gapOffsets = new GrowableIntArray(12);
            this.data = new GrowableByteArray(sequence.length);
            int offset = 0;
            for (int i = 0; i < sequence.length; ++i) {
                char c = sequence[i];
                Nucleotide n = Nucleotide.parseOrNull(c);
                if (n == null) continue;
                this.handle(n, offset);
                ++offset;
            }
        }

        public NewValues(NucleotideSequence sequence) {
            this.nOffsets = new GrowableIntArray(12);
            this.gapOffsets = new GrowableIntArray(sequence.getNumberOfGaps());
            this.data = new GrowableByteArray((int)sequence.getLength());
            int offset = 0;
            for (Nucleotide n : sequence) {
                this.handle(n, offset);
                ++offset;
            }
        }

        public NewValues(Iterator<Nucleotide> iter) {
            this.nOffsets = new GrowableIntArray(12);
            this.gapOffsets = new GrowableIntArray(12);
            this.data = new GrowableByteArray(100);
            int offset = 0;
            while (iter.hasNext()) {
                Nucleotide n = iter.next();
                this.handle(n, offset);
                ++offset;
            }
        }

        public NewValues(Iterable<Nucleotide> nucleotides) {
            this.nOffsets = new GrowableIntArray(12);
            this.gapOffsets = new GrowableIntArray(12);
            this.data = new GrowableByteArray(100);
            int offset = 0;
            for (Nucleotide n : nucleotides) {
                this.handle(n, offset);
                ++offset;
            }
        }

        private void handle(Nucleotide n, int offset) {
            byte value = n.getOrdinalAsByte();
            this.data.append(value);
            switch (value) {
                case 0: {
                    this.nOffsets.append(offset);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 11: {
                    this.gapOffsets.append(offset);
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    ++this.numberOfACGTs;
                    break;
                }
                case 15: {
                    ++this.numberOfACGTs;
                    ++this.numTs;
                    break;
                }
                case 16: {
                    ++this.numberOfACGTs;
                    ++this.numUs;
                    break;
                }
            }
        }

        private void handleOrdinal(byte ordinal, int offset) {
            switch (ordinal) {
                case 0: {
                    this.nOffsets.append(offset);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 11: {
                    this.gapOffsets.append(offset);
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    ++this.numberOfACGTs;
                    break;
                }
                case 15: {
                    ++this.numberOfACGTs;
                    ++this.numTs;
                    break;
                }
                case 16: {
                    ++this.numberOfACGTs;
                    ++this.numUs;
                    break;
                }
            }
        }

        public int getnumberOfNonNAmiguities() {
            return this.getLength() - (this.getNumberOfGaps() + this.getNumberOfNs() + this.numberOfACGTs);
        }

        public GrowableByteArray getData() {
            return this.data;
        }

        public int getLength() {
            return this.data.getCurrentLength();
        }

        public int getNumberOfGaps() {
            return this.gapOffsets.getCurrentLength();
        }

        public int getNumberOfNs() {
            return this.nOffsets.getCurrentLength();
        }

        public GrowableIntArray getGapOffsets() {
            return this.gapOffsets;
        }

        public GrowableIntArray getNOffsets() {
            return this.nOffsets;
        }
    }

    private static class AlignedReference {
        private final NucleotideSequence reference;
        private final int offset;

        public AlignedReference(NucleotideSequence reference, int offset) {
            long length = reference.getLength();
            if ((long)offset > length) {
                throw new IllegalArgumentException(String.format("invalid offset %d is beyond reference length %d", offset, length));
            }
            this.reference = reference;
            this.offset = offset;
        }
    }

    private static final class CodecDecider {
        private int numberOfNonNAmbiguities = 0;
        private int numUs = 0;
        private int numTs = 0;
        private int currentLength = 0;
        private AlignedReference alignedReference = null;
        private GrowableIntArray gapOffsets;
        private GrowableIntArray nOffsets;
        private boolean forceBasicCodec = false;

        CodecDecider() {
            this.gapOffsets = new GrowableIntArray(12);
            this.nOffsets = new GrowableIntArray(12);
        }

        public NucleotideSequence encode(Iterator<Nucleotide> iterator) {
            int twoBitBufferSize;
            boolean hasTs;
            int numberOfGaps = this.gapOffsets.getCurrentLength();
            int numberOfNs = this.nOffsets.getCurrentLength();
            boolean hasUs = this.numUs > 0;
            boolean bl = hasTs = this.numTs > 0;
            if (this.forceBasicCodec || this.numberOfNonNAmbiguities > 0 || numberOfGaps > 0 && numberOfNs > 0 || hasUs && hasTs) {
                byte[] encodedBytes = BasicNucleotideCodec.INSTANCE.encode(this.currentLength, this.gapOffsets.toArray(), iterator);
                return new DefaultNucleotideSequence(BasicNucleotideCodec.INSTANCE, encodedBytes, hasUs, hasUs && !hasTs);
            }
            int fourBitBufferSize = BasicNucleotideCodec.INSTANCE.getNumberOfEncodedBytesFor(this.currentLength, numberOfGaps);
            if (fourBitBufferSize < (twoBitBufferSize = AcgtnNucloetideCodec.INSTANCE.getNumberOfEncodedBytesFor(this.currentLength, Math.max(numberOfGaps, numberOfNs)))) {
                byte[] encodedBytes = BasicNucleotideCodec.INSTANCE.encode(this.currentLength, this.gapOffsets.toArray(), iterator);
                return new DefaultNucleotideSequence(BasicNucleotideCodec.INSTANCE, encodedBytes, hasUs, hasUs && !hasTs);
            }
            if (numberOfGaps == 0) {
                byte[] encodedBytes = AcgtnNucloetideCodec.INSTANCE.encode(this.currentLength, this.nOffsets.toArray(), iterator);
                return new DefaultNucleotideSequence(AcgtnNucloetideCodec.INSTANCE, encodedBytes, hasUs, hasUs && !hasTs);
            }
            byte[] encodedBytes = AcgtGapNucleotideCodec.INSTANCE.encode(this.currentLength, this.gapOffsets.toArray(), iterator);
            return new DefaultNucleotideSequence(AcgtGapNucleotideCodec.INSTANCE, encodedBytes, hasUs, hasUs && !hasTs);
        }

        CodecDecider(NewValues newValues) {
            this.nOffsets = newValues.getNOffsets().copy();
            this.currentLength = newValues.getLength();
            this.numberOfNonNAmbiguities = newValues.getnumberOfNonNAmiguities();
            this.numUs = newValues.numUs;
            this.numTs = newValues.numTs;
            this.gapOffsets = newValues.getGapOffsets().copy();
        }

        CodecDecider copy() {
            CodecDecider copy = new CodecDecider();
            copy.numberOfNonNAmbiguities = this.numberOfNonNAmbiguities;
            copy.numUs = this.numUs;
            copy.numTs = this.numTs;
            copy.currentLength = this.currentLength;
            copy.nOffsets = this.nOffsets.copy();
            copy.alignedReference = this.alignedReference;
            copy.gapOffsets = this.gapOffsets.copy();
            return copy;
        }

        void forceBasicCompression(boolean forceBasicCompression) {
            this.forceBasicCodec = forceBasicCompression;
        }

        void clear() {
            this.gapOffsets.clear();
            this.nOffsets.clear();
            this.numberOfNonNAmbiguities = 0;
            this.numUs = 0;
            this.numTs = 0;
            this.currentLength = 0;
            this.alignedReference = null;
        }

        void alignedReference(AlignedReference ref) {
            this.alignedReference = ref;
        }

        boolean hasAlignedReference() {
            return this.alignedReference != null;
        }

        private void append(GrowableIntArray src, GrowableIntArray dest) {
            int[] newGaps = src.toArray();
            int i = 0;
            while (i < newGaps.length) {
                int n = i++;
                newGaps[n] = newGaps[n] + this.currentLength;
            }
            dest.append(newGaps);
        }

        public void append(NucleotideSequenceBuilder other) {
            CodecDecider otherDecider = other.codecDecider;
            this.append(otherDecider.gapOffsets, this.gapOffsets);
            this.append(otherDecider.nOffsets, this.nOffsets);
            this.currentLength = (int)((long)this.currentLength + other.getLength());
            this.numberOfNonNAmbiguities += otherDecider.numberOfNonNAmbiguities;
            this.numUs += otherDecider.numUs;
            this.numTs += otherDecider.numTs;
        }

        public void append(NewValues newValues) {
            this.append(newValues.getGapOffsets(), this.gapOffsets);
            this.append(newValues.getNOffsets(), this.nOffsets);
            this.currentLength += newValues.getLength();
            this.numberOfNonNAmbiguities += newValues.getnumberOfNonNAmiguities();
            this.numUs += newValues.numUs;
            this.numTs += newValues.numTs;
        }

        private void insert(GrowableIntArray src, GrowableIntArray dest, int insertionOffset, int insertionLength) {
            int currentGapLength = dest.getCurrentLength();
            int insertLength = insertionLength;
            for (int i = 0; i < currentGapLength; ++i) {
                int currentValue = dest.get(i);
                if (currentValue < insertionOffset) continue;
                dest.replace(i, currentValue + insertLength);
            }
            int[] newGaps = src.toArray();
            int i = 0;
            while (i < newGaps.length) {
                int n = i++;
                newGaps[n] = newGaps[n] + insertionOffset;
            }
            dest.sortedInsert(newGaps);
        }

        public void insert(int startOffset, NewValues newValues) {
            int insertLength = newValues.getLength();
            if (startOffset == 0) {
                this.gapOffsets = this.prepend(newValues.getGapOffsets(), this.gapOffsets, insertLength);
                this.nOffsets = this.prepend(newValues.getNOffsets(), this.nOffsets, insertLength);
            } else {
                this.insert(newValues.getGapOffsets(), this.gapOffsets, startOffset, insertLength);
                this.insert(newValues.getNOffsets(), this.nOffsets, startOffset, insertLength);
            }
            this.currentLength += insertLength;
            this.numberOfNonNAmbiguities += newValues.getnumberOfNonNAmiguities();
            this.numUs += newValues.numUs;
            this.numTs += newValues.numTs;
        }

        private GrowableIntArray prepend(GrowableIntArray src, GrowableIntArray original, int insertionLength) {
            int[] oldGaps = original.toArray();
            int i = 0;
            while (i < oldGaps.length) {
                int n = i++;
                oldGaps[n] = oldGaps[n] + insertionLength;
            }
            GrowableIntArray newOffsets = new GrowableIntArray(insertionLength + original.getCurrentCapacity());
            newOffsets.append(src);
            newOffsets.append(oldGaps);
            return newOffsets;
        }

        public void reverse() {
            this.gapOffsets = this.reverseCoordinates(this.gapOffsets);
            this.nOffsets = this.reverseCoordinates(this.nOffsets);
        }

        private GrowableIntArray reverseCoordinates(GrowableIntArray array) {
            int[] gaps = array.toArray();
            int delta = this.currentLength - 1;
            for (int i = 0; i < gaps.length; ++i) {
                gaps[i] = delta - gaps[i];
            }
            GrowableIntArray newArray = new GrowableIntArray(array.getCurrentCapacity());
            newArray.append(gaps);
            newArray.reverse();
            return newArray;
        }

        private void delete(GrowableIntArray array, int startOffset, int[] gapsToDelete, int lengthDeleted) {
            for (int i = 0; i < gapsToDelete.length; ++i) {
                array.sortedRemove(gapsToDelete[i] + startOffset);
            }
            int lastGap = startOffset + lengthDeleted - 1;
            int remainingGapLength = array.getCurrentLength();
            for (int i = -array.binarySearch(lastGap) - 1; i < remainingGapLength; ++i) {
                try {
                    if (array.get(i) <= lastGap) continue;
                    array.replace(i, array.get(i) - lengthDeleted);
                    continue;
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        }

        public void delete(int startOffset, NewValues newValues) {
            this.delete(this.gapOffsets, startOffset, newValues.getGapOffsets().toArray(), newValues.getLength());
            this.delete(this.nOffsets, startOffset, newValues.getNOffsets().toArray(), newValues.getLength());
            this.currentLength -= newValues.getLength();
            this.numberOfNonNAmbiguities -= newValues.getnumberOfNonNAmiguities();
            this.numUs -= newValues.numUs;
            this.numTs -= newValues.numTs;
        }

        public void replace(int offset, byte oldValue, byte newValue) {
            this.handleReplacementValue(offset, oldValue, false);
            this.handleReplacementValue(offset, newValue, true);
        }

        void handleReplacementValue(int offset, int value, boolean insert) {
            if (value == GAP_VALUE) {
                this.replaceValue(this.gapOffsets, offset, insert);
            } else if (value == N_VALUE) {
                this.replaceValue(this.nOffsets, offset, insert);
            } else if (value != A_VALUE && value != C_VALUE && value != G_VALUE && value != T_VALUE) {
                this.handleAmbiguity(insert);
            }
        }

        private void replaceValue(GrowableIntArray array, int offset, boolean insert) {
            if (insert) {
                array.sortedInsert(offset);
            } else {
                array.sortedRemove(offset);
            }
        }

        private void handleAmbiguity(boolean increment) {
            this.numberOfNonNAmbiguities = increment ? ++this.numberOfNonNAmbiguities : --this.numberOfNonNAmbiguities;
        }

        void ungap() {
            int[] gaps = this.gapOffsets.toArray();
            int[] newNOffsets = new int[this.nOffsets.getCurrentLength()];
            PeekableIterator<Integer> gapOffsetIter = IteratorUtil.createPeekableIterator(this.gapOffsets.iterator());
            Iterator<Integer> nOffsetIter = this.nOffsets.iterator();
            int shiftSize = 0;
            int i = 0;
            while (nOffsetIter.hasNext()) {
                int nextGapOffset;
                int currentNOffset = nOffsetIter.next();
                while (gapOffsetIter.hasNext() && (nextGapOffset = gapOffsetIter.peek().intValue()) < currentNOffset) {
                    ++shiftSize;
                    gapOffsetIter.next();
                }
                newNOffsets[i] = currentNOffset - shiftSize;
                ++i;
            }
            this.nOffsets = new GrowableIntArray(newNOffsets);
            this.currentLength -= gaps.length;
            this.gapOffsets.clear();
        }

        int getNumberOfGaps() {
            return this.gapOffsets.getCurrentLength();
        }

        int getNumberOfAmbiguities() {
            return this.numberOfNonNAmbiguities + this.getNumberOfNs();
        }

        int getNumberOfNs() {
            return this.nOffsets.getCurrentLength();
        }

        int getCurrentLength() {
            return this.currentLength;
        }
    }
}

