/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.residue.nt;

import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.ResidueSequence;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;

public interface NucleotideSequence
extends ResidueSequence<Nucleotide, NucleotideSequence, NucleotideSequenceBuilder>,
Serializable {
    @Override
    public boolean equals(Object var1);

    @Override
    public int hashCode();

    @Override
    public NucleotideSequenceBuilder toBuilder();

    @Override
    default public NucleotideSequenceBuilder newEmptyBuilder() {
        return new NucleotideSequenceBuilder();
    }

    @Override
    default public NucleotideSequenceBuilder newEmptyBuilder(int initialCapacity) {
        return new NucleotideSequenceBuilder(initialCapacity);
    }

    default public Stream<Range> findMatches(String regex) {
        return this.findMatches(Pattern.compile(regex));
    }

    default public Stream<Range> findMatches(String regex, boolean nested) {
        return this.findMatches(Pattern.compile(regex), nested);
    }

    default public Stream<Range> findMatches(String regex, Range subSequenceRange) {
        return this.findMatches(Pattern.compile(regex), subSequenceRange);
    }

    default public Stream<Range> findMatches(String regex, Range subSequenceRange, boolean nested) {
        return this.findMatches(Pattern.compile(regex), subSequenceRange, nested);
    }

    public Stream<Range> findMatches(Pattern var1);

    public Stream<Range> findMatches(Pattern var1, Range var2);

    default public Stream<Range> findMatches(Pattern pattern, boolean nested) {
        return this.findMatches(pattern, Range.ofLength(this.getLength()), nested);
    }

    default public Stream<Range> findMatches(Pattern pattern, Range subSequenceRange, boolean nested) {
        Stream<Range> matches = this.findMatches(pattern, subSequenceRange);
        if (!nested) {
            return matches;
        }
        List matchList = matches.collect(Collectors.toList());
        Stream<Range> nestedOutput = matchList.stream();
        long matchCount = matchList.size();
        long sequenceLength = this.getLength();
        int i = 0;
        int j = 0;
        while ((long)i < matchCount) {
            long start = ((Range)matchList.get(i)).getBegin();
            long end = sequenceLength;
            if ((long)j < matchCount) {
                end = ((Range)matchList.get(j)).getEnd() - 1L;
            }
            if (end - start > 0L) {
                nestedOutput = Stream.concat(nestedOutput, this.findMatches(pattern, Range.of(start + 1L, end), nested));
                nestedOutput = Stream.concat(nestedOutput, this.findMatches(pattern, Range.of(start, end - 1L), nested));
            }
            if (end - start > 1L) {
                nestedOutput = Stream.concat(nestedOutput, this.findMatches(pattern, Range.of(start + 1L, end - 1L), nested));
            }
            ++i;
            ++j;
        }
        return nestedOutput;
    }

    public List<Range> getRangesOfNs();

    public static NucleotideSequence of(Iterable<Nucleotide> sequence) {
        return new NucleotideSequenceBuilder(sequence).turnOffDataCompression(true).build();
    }

    public static NucleotideSequence of(String sequence) {
        return new NucleotideSequenceBuilder(sequence).turnOffDataCompression(true).build();
    }

    public boolean isDna();

    default public boolean isRna() {
        return !this.isDna();
    }
}

