/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.residue.nt;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.internal.core.GlyphCodec;
import org.jcvi.jillion.internal.core.io.StreamUtil;

interface NucleotideCodec
extends GlyphCodec<Nucleotide> {
    public byte[] encode(int var1, int[] var2, Iterator<Nucleotide> var3);

    public List<Integer> getGapOffsets(byte[] var1);

    public int getNumberOfGaps(byte[] var1);

    public boolean isGap(byte[] var1, int var2);

    public long getUngappedLength(byte[] var1);

    public long getLength(byte[] var1);

    public int getNumberOfGapsUntil(byte[] var1, int var2);

    public int getUngappedOffsetFor(byte[] var1, int var2);

    public int getGappedOffsetFor(byte[] var1, int var2);

    default public Range toUngappedRange(byte[] encodedData, Range gappedRange) {
        if (gappedRange == null) {
            throw new NullPointerException("gappedRange can not be null");
        }
        return Range.of(this.getUngappedOffsetFor(encodedData, (int)gappedRange.getBegin()), (long)this.getUngappedOffsetFor(encodedData, (int)gappedRange.getEnd()));
    }

    default public Range toGappedRange(byte[] encodedData, Range ungappedRange) {
        if (ungappedRange == null) {
            throw new NullPointerException("ungappedRange can not be null");
        }
        return Range.of(this.getGappedOffsetFor(encodedData, (int)ungappedRange.getBegin()), (long)this.getGappedOffsetFor(encodedData, (int)ungappedRange.getEnd()));
    }

    public byte[] encode(Nucleotide var1);

    public Iterator<Nucleotide> iterator(byte[] var1);

    public Iterator<Nucleotide> iterator(byte[] var1, Range var2);

    public String toString(byte[] var1);

    default public String toString(byte[] encodedData, Range subRange) {
        StringBuilder builder = new StringBuilder((int)subRange.getLength());
        Iterator<Nucleotide> iter = this.iterator(encodedData, subRange);
        while (iter.hasNext()) {
            builder.append(iter.next());
        }
        return builder.toString();
    }

    public List<Range> getNRanges(byte[] var1);

    default public Stream<Range> matches(byte[] encodedData, String regex) {
        return this.matches(encodedData, Pattern.compile(regex));
    }

    default public Stream<Range> matches(byte[] encodedData, Pattern pattern) {
        Matcher matcher = pattern.matcher(this.toString(encodedData));
        return StreamUtil.newGeneratedStream(() -> matcher.find() ? Optional.of(Range.of(matcher.start(), (long)(matcher.end() - 1))) : Optional.empty());
    }

    default public Stream<Range> matches(byte[] encodedData, Pattern pattern, Range range) {
        Matcher matcher = pattern.matcher(this.toString(encodedData, range));
        return StreamUtil.newGeneratedStream(() -> matcher.find() ? Optional.of(new Range.Builder(matcher.start(), matcher.end() - 1).shift(range.getBegin()).build()) : Optional.empty());
    }

    default public Stream<Range> matches(byte[] encodedData, String regex, boolean nested) {
        return this.matches(encodedData, Pattern.compile(regex), nested);
    }

    default public Stream<Range> matches(byte[] encodedData, Pattern pattern, boolean nested) {
        return this.matches(encodedData, pattern, Range.ofLength(this.getLength(encodedData)), nested);
    }

    default public Stream<Range> matches(byte[] encodedData, Pattern pattern, Range range, boolean nested) {
        Stream<Range> matches = this.matches(encodedData, pattern, range);
        if (!nested) {
            return matches;
        }
        List matchesList = matches.collect(Collectors.toList());
        Stream<Range> nestedMatches = matchesList.stream();
        if (matchesList.isEmpty()) {
            return Stream.empty();
        }
        int matchCount = matchesList.size();
        int i = 0;
        int j = 1;
        while (i < matchCount) {
            long start = ((Range)matchesList.get(i)).getBegin();
            long end = range.getEnd();
            if (j < matchCount) {
                end = ((Range)matchesList.get(j)).getEnd() - 1L;
            }
            if (end - start > 0L) {
                nestedMatches = Stream.concat(nestedMatches, this.matches(encodedData, pattern, Range.of(start, end - 1L), true));
                nestedMatches = Stream.concat(nestedMatches, this.matches(encodedData, pattern, Range.of(start + 1L, end), true));
            }
            if (end - start > 1L) {
                nestedMatches = Stream.concat(nestedMatches, this.matches(encodedData, pattern, Range.of(start + 1L, end - 1L), true));
            }
            ++i;
            ++j;
        }
        return nestedMatches;
    }
}

