/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.residue.nt;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jcvi.jillion.core.residue.Residue;

public enum Nucleotide implements Residue
{
    Unknown(Character.valueOf('N')),
    NotThymine(Character.valueOf('V')),
    NotGuanine(Character.valueOf('H')),
    NotCytosine(Character.valueOf('D')),
    NotAdenine(Character.valueOf('B')),
    Weak(Character.valueOf('W')),
    Amino(Character.valueOf('M')),
    Purine(Character.valueOf('R')),
    Strong(Character.valueOf('S')),
    Pyrimidine(Character.valueOf('Y')),
    Keto(Character.valueOf('K')),
    Gap(Character.valueOf('-')),
    Adenine(Character.valueOf('A')),
    Cytosine(Character.valueOf('C')),
    Guanine(Character.valueOf('G')),
    Thymine(Character.valueOf('T')),
    Uracil(Character.valueOf('U'));

    private static final Map<Nucleotide, Set<Nucleotide>> AMBIGUITY_TO_CONSTIUENT;
    private static final Map<Nucleotide, Set<Nucleotide>> CONSTIUENT_TO_AMBIGUITY;
    private static Nucleotide[] CACHE;
    private static final Nucleotide[] VALUES_ARRAY;
    private static final Nucleotide[] DNA_VALUES_ARRAY;
    private static final Nucleotide[] RNA_VALUES_ARRAY;
    private static final Set<Nucleotide> GAP_BASES_FOR;
    public static final List<Nucleotide> DNA_VALUES;
    public static final List<Nucleotide> RNA_VALUES;
    public static final List<Nucleotide> ALL_VALUES;
    private final Character c;

    private static int computeOffsetFor(char c) {
        return c - 42;
    }

    private Nucleotide(Character c) {
        this.c = c;
    }

    @Override
    public Character getCharacter() {
        return this.c;
    }

    public Nucleotide complement() {
        Nucleotide ret = null;
        switch (this) {
            case Unknown: {
                ret = Unknown;
                break;
            }
            case NotThymine: {
                ret = NotAdenine;
                break;
            }
            case NotGuanine: {
                ret = NotCytosine;
                break;
            }
            case NotCytosine: {
                ret = NotGuanine;
                break;
            }
            case NotAdenine: {
                ret = NotThymine;
                break;
            }
            case Weak: {
                ret = Weak;
                break;
            }
            case Amino: {
                ret = Keto;
                break;
            }
            case Purine: {
                ret = Pyrimidine;
                break;
            }
            case Strong: {
                ret = Strong;
                break;
            }
            case Pyrimidine: {
                ret = Purine;
                break;
            }
            case Keto: {
                ret = Amino;
                break;
            }
            case Gap: {
                ret = Gap;
                break;
            }
            case Adenine: {
                ret = Thymine;
                break;
            }
            case Cytosine: {
                ret = Guanine;
                break;
            }
            case Guanine: {
                ret = Cytosine;
                break;
            }
            case Thymine: 
            case Uracil: {
                ret = Adenine;
                break;
            }
            default: {
                throw new IllegalStateException("a new nucleotide ordinal has been added" + this);
            }
        }
        return ret;
    }

    public static List<Nucleotide> getDnaValues() {
        return DNA_VALUES;
    }

    public static List<Nucleotide> getAllValues() {
        return ALL_VALUES;
    }

    public static List<Nucleotide> getRnaValues() {
        return RNA_VALUES;
    }

    public static Nucleotide parse(String base) {
        return Nucleotide.parse(base.charAt(0));
    }

    public static Nucleotide parse(char base) {
        Nucleotide ret = Nucleotide.parseOrNull(base);
        if (ret == null) {
            throw new IllegalArgumentException("invalid character " + base + " ascii value " + base);
        }
        return ret;
    }

    protected static Nucleotide parseOrNull(char base) {
        if (base == ' ' || base >= '\u0000' && base <= '\r') {
            return null;
        }
        int offset = Nucleotide.computeOffsetFor(base);
        Nucleotide ret = null;
        if (offset >= 0 && offset < CACHE.length) {
            ret = CACHE[offset];
        }
        if (ret == null) {
            throw new IllegalArgumentException("invalid character " + base + " ascii value " + base);
        }
        return ret;
    }

    public String toString() {
        return this.c.toString();
    }

    @Override
    public boolean isGap() {
        return this == Gap;
    }

    public boolean isAmbiguity() {
        return !this.isGap() && this != Adenine && this != Cytosine && this != Guanine && this != Thymine;
    }

    @Override
    public byte getOrdinalAsByte() {
        return (byte)this.ordinal();
    }

    public Set<Nucleotide> getAllPossibleAmbiguities() {
        if (CONSTIUENT_TO_AMBIGUITY.containsKey(this)) {
            return EnumSet.copyOf(CONSTIUENT_TO_AMBIGUITY.get(this));
        }
        return EnumSet.noneOf(Nucleotide.class);
    }

    public static Nucleotide getAmbiguityFor(Collection<Nucleotide> unambiguiousBases) {
        if (unambiguiousBases == null) {
            throw new NullPointerException("unambiguousBases can not be null");
        }
        Collection<Nucleotide> bases = unambiguiousBases;
        boolean hadU = false;
        if (unambiguiousBases.contains(Uracil)) {
            bases = EnumSet.copyOf(unambiguiousBases);
            bases.remove(Uracil);
            bases.add(Thymine);
            hadU = true;
        }
        for (Map.Entry<Nucleotide, Set<Nucleotide>> entry : AMBIGUITY_TO_CONSTIUENT.entrySet()) {
            if (!bases.containsAll((Collection)entry.getValue())) continue;
            Nucleotide ret = entry.getKey();
            if (hadU && ret == Thymine) {
                return Uracil;
            }
            return ret;
        }
        return Gap;
    }

    public Set<Nucleotide> getBasesFor() {
        if (this == Gap) {
            return GAP_BASES_FOR;
        }
        return AMBIGUITY_TO_CONSTIUENT.get(this);
    }

    public static Nucleotide getByOrdinal(int ordinal) {
        return VALUES_ARRAY[ordinal];
    }

    public boolean matches(Nucleotide other) {
        if (other == null) {
            throw new NullPointerException("other can not be null");
        }
        if (this == other) {
            return true;
        }
        Set<Nucleotide> basesForOther = other.getBasesFor();
        Set<Nucleotide> basesForThis = this.getBasesFor();
        return basesForThis.containsAll(basesForOther) || basesForOther.containsAll(basesForThis);
    }

    static {
        CACHE = new Nucleotide[80];
        VALUES_ARRAY = Nucleotide.values();
        GAP_BASES_FOR = EnumSet.of(Gap);
        AMBIGUITY_TO_CONSTIUENT = new EnumMap<Nucleotide, Set<Nucleotide>>(Nucleotide.class);
        AMBIGUITY_TO_CONSTIUENT.put(Unknown, EnumSet.of(Adenine, Cytosine, Guanine, Thymine));
        AMBIGUITY_TO_CONSTIUENT.put(NotThymine, EnumSet.of(Adenine, Cytosine, Guanine));
        AMBIGUITY_TO_CONSTIUENT.put(NotGuanine, EnumSet.of(Adenine, Cytosine, Thymine));
        AMBIGUITY_TO_CONSTIUENT.put(NotCytosine, EnumSet.of(Adenine, Guanine, Thymine));
        AMBIGUITY_TO_CONSTIUENT.put(NotAdenine, EnumSet.of(Cytosine, Guanine, Thymine));
        AMBIGUITY_TO_CONSTIUENT.put(Weak, EnumSet.of(Adenine, Thymine));
        AMBIGUITY_TO_CONSTIUENT.put(Amino, EnumSet.of(Adenine, Cytosine));
        AMBIGUITY_TO_CONSTIUENT.put(Purine, EnumSet.of(Adenine, Guanine));
        AMBIGUITY_TO_CONSTIUENT.put(Strong, EnumSet.of(Cytosine, Guanine));
        AMBIGUITY_TO_CONSTIUENT.put(Pyrimidine, EnumSet.of(Cytosine, Thymine));
        AMBIGUITY_TO_CONSTIUENT.put(Keto, EnumSet.of(Guanine, Thymine));
        AMBIGUITY_TO_CONSTIUENT.put(Adenine, EnumSet.of(Adenine));
        AMBIGUITY_TO_CONSTIUENT.put(Cytosine, EnumSet.of(Cytosine));
        AMBIGUITY_TO_CONSTIUENT.put(Guanine, EnumSet.of(Guanine));
        AMBIGUITY_TO_CONSTIUENT.put(Thymine, EnumSet.of(Thymine));
        AMBIGUITY_TO_CONSTIUENT.put(Uracil, EnumSet.of(Uracil));
        CONSTIUENT_TO_AMBIGUITY = new EnumMap<Nucleotide, Set<Nucleotide>>(Nucleotide.class);
        for (Nucleotide nucleotide : EnumSet.of(Adenine, Cytosine, Guanine, Thymine, Uracil)) {
            CONSTIUENT_TO_AMBIGUITY.put(nucleotide, EnumSet.noneOf(Nucleotide.class));
        }
        for (Map.Entry entry : AMBIGUITY_TO_CONSTIUENT.entrySet()) {
            for (Nucleotide nucleotide : (Set)entry.getValue()) {
                Nucleotide toAdd = (Nucleotide)entry.getKey();
                if (toAdd == nucleotide) continue;
                CONSTIUENT_TO_AMBIGUITY.get(nucleotide).add(toAdd);
            }
        }
        CONSTIUENT_TO_AMBIGUITY.put(Uracil, CONSTIUENT_TO_AMBIGUITY.get(Thymine));
        for (Iterator<Object> iterator : VALUES_ARRAY) {
            char uppercase = ((Nucleotide)((Object)iterator)).c.charValue();
            char lowercase = Character.toLowerCase(uppercase);
            Nucleotide.CACHE[Nucleotide.computeOffsetFor((char)uppercase)] = iterator;
            Nucleotide.CACHE[Nucleotide.computeOffsetFor((char)lowercase)] = iterator;
        }
        Nucleotide.CACHE[Nucleotide.computeOffsetFor((char)'*')] = Gap;
        Nucleotide.CACHE[Nucleotide.computeOffsetFor((char)'x')] = Unknown;
        Nucleotide.CACHE[Nucleotide.computeOffsetFor((char)'X')] = Unknown;
        DNA_VALUES_ARRAY = new Nucleotide[16];
        RNA_VALUES_ARRAY = new Nucleotide[16];
        try {
            System.arraycopy(VALUES_ARRAY, 0, DNA_VALUES_ARRAY, 0, 16);
            System.arraycopy(VALUES_ARRAY, 0, RNA_VALUES_ARRAY, 0, 15);
            Nucleotide.RNA_VALUES_ARRAY[15] = Uracil;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        DNA_VALUES = Collections.unmodifiableList(Arrays.asList(DNA_VALUES_ARRAY));
        RNA_VALUES = Collections.unmodifiableList(Arrays.asList(RNA_VALUES_ARRAY));
        ALL_VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

