/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.residue.nt;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.Ranges;
import org.jcvi.jillion.core.Sequence;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.residue.nt.ReferenceMappedNucleotideSequence;
import org.jcvi.jillion.core.util.iter.ArrayIterator;
import org.jcvi.jillion.internal.core.io.StreamUtil;
import org.jcvi.jillion.internal.core.io.ValueSizeStrategy;
import org.jcvi.jillion.internal.core.residue.AbstractResidueSequence;
import org.jcvi.jillion.internal.core.util.ArrayUtil;
import org.jcvi.jillion.internal.core.util.GrowableIntArray;

final class DefaultReferenceEncodedNucleotideSequence
extends AbstractResidueSequence<Nucleotide, NucleotideSequence, NucleotideSequenceBuilder>
implements ReferenceMappedNucleotideSequence {
    private static final long serialVersionUID = 938806681397322051L;
    private final int length;
    private final int startOffset;
    private final NucleotideSequence reference;
    private final byte[] encodedSnpsInfo;
    private transient int hash;
    private Boolean isDna;

    @Override
    public SortedMap<Integer, Nucleotide> getDifferenceMap() {
        if (this.encodedSnpsInfo == null) {
            return new TreeMap<Integer, Nucleotide>();
        }
        ByteBuffer buf = ByteBuffer.wrap(this.encodedSnpsInfo);
        ValueSizeStrategy numSnpsSizeStrategy = ValueSizeStrategy.values()[buf.get()];
        int size = numSnpsSizeStrategy.getNext(buf);
        ValueSizeStrategy snpSizeStrategy = ValueSizeStrategy.values()[buf.get()];
        byte[] snps = this.getSnpArray(numSnpsSizeStrategy, size, snpSizeStrategy);
        TreeMap<Integer, Nucleotide> differenceMap = new TreeMap<Integer, Nucleotide>();
        for (int i = 0; i < size; ++i) {
            Integer offset = snpSizeStrategy.getNext(buf);
            int index = i / 2;
            if (i % 2 == 0) {
                int temp1 = snps[index] >> 4;
                differenceMap.put(offset, Nucleotide.getDnaValues().get(temp1 & 0xF));
                continue;
            }
            differenceMap.put(offset, Nucleotide.getDnaValues().get(snps[index] & 0xF));
        }
        return differenceMap;
    }

    DefaultReferenceEncodedNucleotideSequence(NucleotideSequence reference, String toBeEncoded, int startOffset) {
        this(reference, new NucleotideSequenceBuilder(toBeEncoded), startOffset);
    }

    DefaultReferenceEncodedNucleotideSequence(NucleotideSequence reference, NucleotideSequenceBuilder toBeEncoded, int startOffset) {
        this(reference, toBeEncoded, startOffset, toBeEncoded.getNumUs() > 0);
    }

    DefaultReferenceEncodedNucleotideSequence(NucleotideSequence reference, NucleotideSequenceBuilder toBeEncoded, int startOffset, boolean isRna) {
        this.startOffset = startOffset;
        this.length = (int)toBeEncoded.getLength();
        this.reference = reference;
        this.isDna = !isRna;
        SortedMap<Integer, Nucleotide> differentGlyphMap = this.populateFields(reference, toBeEncoded, startOffset);
        int numSnps = differentGlyphMap.size();
        if (numSnps == 0) {
            this.encodedSnpsInfo = null;
            return;
        }
        ValueSizeStrategy snpSizeStrategy = ValueSizeStrategy.getStrategyFor(differentGlyphMap.lastKey());
        int snpByteLength = this.computeNumberOfBytesToStore(numSnps, snpSizeStrategy);
        ValueSizeStrategy numSnpsStrategy = ValueSizeStrategy.getStrategyFor(snpByteLength);
        int bufferSize = numSnpsStrategy.getNumberOfBytesPerValue() + snpByteLength;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        buffer.put((byte)numSnpsStrategy.ordinal());
        numSnpsStrategy.put(buffer, numSnps);
        buffer.put((byte)snpSizeStrategy.ordinal());
        int i = 0;
        byte[] snpValues = new byte[(numSnps + 1) / 2];
        for (Map.Entry<Integer, Nucleotide> entry : differentGlyphMap.entrySet()) {
            snpSizeStrategy.put(buffer, entry.getKey());
            byte ordinal = entry.getValue().getOrdinalAsByte();
            if (isRna && ordinal == Nucleotide.Uracil.getOrdinalAsByte()) {
                ordinal = Nucleotide.Thymine.getOrdinalAsByte();
            }
            int index = i / 2;
            snpValues[index] = i % 2 == 0 ? (byte)(ordinal << 4 & 0xF0) : (byte)(snpValues[index] | ordinal);
            ++i;
        }
        buffer.put(snpValues);
        this.encodedSnpsInfo = buffer.array();
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.isDna == null) {
            this.isDna = true;
        }
    }

    @Override
    public boolean isDna() {
        return this.isDna;
    }

    @Override
    public Stream<Range> findMatches(Pattern pattern) {
        Matcher matcher = pattern.matcher(this.toString());
        return StreamUtil.newGeneratedStream(() -> matcher.find() ? Optional.of(Range.of(matcher.start(), (long)(matcher.end() - 1))) : Optional.empty());
    }

    @Override
    public Stream<Range> findMatches(Pattern pattern, Range subSequenceRange) {
        Matcher matcher = pattern.matcher(this.toString(subSequenceRange));
        return StreamUtil.newGeneratedStream(() -> matcher.find() ? Optional.of(new Range.Builder(matcher.start(), matcher.end() - 1).shift(subSequenceRange.getBegin()).build()) : Optional.empty());
    }

    private int computeNumberOfBytesToStore(int numSnps, ValueSizeStrategy snpSizeStrategy) {
        int numBytesPerSnpIndex = snpSizeStrategy.getNumberOfBytesPerValue();
        int numBytesRequiredToStoreSnps = (numSnps + 1) / 2;
        int numberOfBytesToStoreSnpOffsets = numBytesPerSnpIndex * numSnps;
        return 2 + numberOfBytesToStoreSnpOffsets + numBytesRequiredToStoreSnps;
    }

    private SortedMap<Integer, Nucleotide> populateFields(NucleotideSequence reference, NucleotideSequenceBuilder toBeEncoded, int startOffset) {
        this.handleBeforeReference(startOffset);
        this.handleAfterReference(reference, toBeEncoded, startOffset);
        TreeMap<Integer, Nucleotide> differentGlyphMap = new TreeMap<Integer, Nucleotide>();
        Iterator<Nucleotide> readIterator = toBeEncoded.iterator();
        Iterator refIterator = reference.iterator(new Range.Builder(this.length).shift(startOffset).build());
        int i = 0;
        while (readIterator.hasNext()) {
            Nucleotide referenceGlyph;
            Nucleotide g = readIterator.next();
            if (this.isDifferent(g, referenceGlyph = (Nucleotide)refIterator.next())) {
                differentGlyphMap.put(i, g);
            }
            ++i;
        }
        return differentGlyphMap;
    }

    private void handleAfterReference(Sequence<Nucleotide> reference, NucleotideSequenceBuilder toBeEncoded, int startOffset) {
        int lastOffsetOfSequence = (int)toBeEncoded.getLength() + startOffset;
        if ((long)lastOffsetOfSequence > reference.getLength()) {
            int overhang = (int)(toBeEncoded.getLength() + (long)startOffset - reference.getLength());
            throw new IllegalArgumentException(String.format("sequences extends beyond reference by %d base(s)", overhang));
        }
    }

    private void handleBeforeReference(int startOffset) {
        if (startOffset < 0) {
            throw new IllegalArgumentException("can not start before reference: " + startOffset);
        }
    }

    private boolean isDifferent(Nucleotide g, Nucleotide referenceGlyph) {
        return g != referenceGlyph;
    }

    @Override
    public Iterator<Nucleotide> iterator() {
        Nucleotide[] array = this.asNucleotideArray();
        return new ArrayIterator<Nucleotide>(array);
    }

    @Override
    public Iterator<Nucleotide> iterator(Range range) {
        Nucleotide[] array = this.asNucleotideArray(range);
        return new ArrayIterator<Nucleotide>(array);
    }

    private Nucleotide[] createReferenceArray(Range range) {
        Nucleotide[] array = new Nucleotide[(int)range.getLength()];
        Iterator iter = this.reference.iterator(range);
        int i = 0;
        while (iter.hasNext()) {
            array[i] = (Nucleotide)iter.next();
            ++i;
        }
        return array;
    }

    private Nucleotide[] asNucleotideArray(Range range) {
        if (range == null) {
            throw new NullPointerException("range can not be null");
        }
        if (range.getBegin() < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (range.getEnd() >= (long)this.length) {
            throw new IndexOutOfBoundsException(range.getEnd() + " is beyond end of sequence (length = " + this.length + ")");
        }
        Nucleotide[] array = this.asNucleotideArray();
        return Arrays.copyOfRange(array, (int)range.getBegin(), (int)range.getEnd() + 1);
    }

    private Nucleotide[] asNucleotideArray() {
        Nucleotide[] array = this.createReferenceArray(new Range.Builder(this.length).shift(this.startOffset).build());
        if (this.encodedSnpsInfo != null) {
            int i;
            ByteBuffer buf = ByteBuffer.wrap(this.encodedSnpsInfo);
            ValueSizeStrategy numSnpsSizeStrategy = ValueSizeStrategy.values()[buf.get()];
            int size = numSnpsSizeStrategy.getNext(buf);
            ValueSizeStrategy sizeStrategy = ValueSizeStrategy.values()[buf.get()];
            byte[] snps = this.getSnpArray(numSnpsSizeStrategy, size, sizeStrategy);
            for (i = 0; i < size; ++i) {
                int index = sizeStrategy.getNext(buf);
                int snpIndex = i / 2;
                array[index] = i % 2 == 0 ? Nucleotide.getDnaValues().get(snps[snpIndex] >> 4 & 0xF) : Nucleotide.getDnaValues().get(snps[snpIndex] & 0xF);
            }
            if (this.isRna()) {
                for (i = 0; i < array.length; ++i) {
                    if (array[i] != Nucleotide.Thymine) continue;
                    array[i] = Nucleotide.Uracil;
                }
            }
        }
        return array;
    }

    @Override
    public Nucleotide get(long index) {
        if (index < 0L || index >= (long)this.length) {
            throw new IndexOutOfBoundsException("invalid offset " + index);
        }
        if (this.encodedSnpsInfo != null) {
            ByteBuffer buf = ByteBuffer.wrap(this.encodedSnpsInfo);
            ValueSizeStrategy numSnpsSizeStrategy = ValueSizeStrategy.values()[buf.get()];
            int size = numSnpsSizeStrategy.getNext(buf);
            ValueSizeStrategy sizeStrategy = ValueSizeStrategy.values()[buf.get()];
            byte[] snps = this.getSnpArray(numSnpsSizeStrategy, size, sizeStrategy);
            for (int i = 0; i < size; ++i) {
                int nextValue = sizeStrategy.getNext(buf);
                if (index != (long)nextValue) continue;
                int snpIndex = i / 2;
                if (i % 2 == 0) {
                    return Nucleotide.getDnaValues().get(snps[snpIndex] >> 4 & 0xF);
                }
                return Nucleotide.getDnaValues().get(snps[snpIndex] & 0xF);
            }
        }
        long referenceIndex = index + (long)this.startOffset;
        return (Nucleotide)this.reference.get(referenceIndex);
    }

    private byte[] getSnpArray(ValueSizeStrategy numSnpsSizeStrategy, int size, ValueSizeStrategy sizeStrategy) {
        int from = numSnpsSizeStrategy.getNumberOfBytesPerValue() + 2 + size * sizeStrategy.getNumberOfBytesPerValue();
        return Arrays.copyOfRange(this.encodedSnpsInfo, from, this.encodedSnpsInfo.length);
    }

    @Override
    public boolean isGap(int index) {
        return this.getGapOffsets().contains(index);
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public List<Integer> getGapOffsets() {
        GrowableIntArray referenceGapOffsets = this.shiftReferenceGaps();
        if (this.encodedSnpsInfo != null) {
            return this.modifyForSnps(referenceGapOffsets);
        }
        return ArrayUtil.asList(referenceGapOffsets.toArray());
    }

    private List<Integer> modifyForSnps(GrowableIntArray gaps) {
        ByteBuffer buf = ByteBuffer.wrap(this.encodedSnpsInfo);
        int size = ValueSizeStrategy.values()[buf.get()].getNext(buf);
        ValueSizeStrategy sizeStrategy = ValueSizeStrategy.values()[buf.get()];
        GrowableIntArray snps = new GrowableIntArray(size);
        for (int i = 0; i < size; ++i) {
            int snpOffset = sizeStrategy.getNext(buf);
            int index = gaps.binarySearch(snpOffset);
            if (index >= 0) {
                gaps.remove(index);
            }
            snps.append(snpOffset);
        }
        if (buf.hasRemaining()) {
            int numBytesRemaining = buf.remaining();
            byte[] snpArray = Arrays.copyOfRange(this.encodedSnpsInfo, this.encodedSnpsInfo.length - numBytesRemaining, this.encodedSnpsInfo.length);
            for (int i = 0; i < size; ++i) {
                int snpIndex = i / 2;
                Nucleotide snp = i % 2 == 0 ? Nucleotide.getDnaValues().get(snpArray[snpIndex] >> 4 & 0xF) : Nucleotide.getDnaValues().get(snpArray[snpIndex] & 0xF);
                if (Nucleotide.Gap != snp) continue;
                gaps.append(snps.get(i));
            }
        }
        gaps.sort();
        return ArrayUtil.asList(gaps.toArray());
    }

    private GrowableIntArray shiftReferenceGaps() {
        List<Integer> refGapOffsets = this.reference.getGapOffsets();
        GrowableIntArray gaps = new GrowableIntArray(refGapOffsets.size());
        for (Integer refGap : refGapOffsets) {
            int adjustedCoordinate = refGap - this.startOffset;
            if (adjustedCoordinate < 0 || adjustedCoordinate >= this.length) continue;
            gaps.append(adjustedCoordinate);
        }
        return gaps;
    }

    @Override
    public int hashCode() {
        long length = this.getLength();
        if (this.hash == 0 && length > 0L) {
            int prime = 31;
            int result = 1;
            Iterator<Nucleotide> iter = this.iterator();
            while (iter.hasNext()) {
                result = 31 * result + iter.next().hashCode();
            }
            this.hash = result;
        }
        return this.hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NucleotideSequence)) {
            return false;
        }
        NucleotideSequence other = (NucleotideSequence)obj;
        if (this.getLength() != other.getLength()) {
            return false;
        }
        Iterator<Nucleotide> iter = this.iterator();
        Iterator otherIter = other.iterator();
        while (iter.hasNext()) {
            if (iter.next().equals(otherIter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getNumberOfGaps() {
        return this.getGapOffsets().size();
    }

    @Override
    public String toString() {
        Nucleotide[] array = this.asNucleotideArray();
        StringBuilder builder = new StringBuilder(array.length);
        for (int i = 0; i < array.length; ++i) {
            builder.append(array[i]);
        }
        return builder.toString();
    }

    private String toString(Range range) {
        Nucleotide[] array = this.asNucleotideArray(range);
        StringBuilder builder = new StringBuilder(array.length);
        for (int i = 0; i < array.length; ++i) {
            builder.append(array[i]);
        }
        return builder.toString();
    }

    @Override
    public NucleotideSequence getReferenceSequence() {
        return this.reference;
    }

    @Override
    public NucleotideSequenceBuilder toBuilder() {
        return new NucleotideSequenceBuilder(this).setReferenceHint(this.reference, this.startOffset);
    }

    @Override
    public NucleotideSequenceBuilder toBuilder(Range range) {
        return new NucleotideSequenceBuilder(this, range).setReferenceHint(this.reference, (int)((long)this.startOffset + range.getBegin()));
    }

    @Override
    public NucleotideSequence asSubtype() {
        return this;
    }

    @Override
    public List<Range> getRangesOfNs() {
        BitSet bits = new BitSet();
        int offset = 0;
        Iterator<Nucleotide> iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() == Nucleotide.Unknown) {
                bits.set(offset);
            }
            ++offset;
        }
        return Ranges.asRanges(bits);
    }
}

