/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.residue.nt;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.LongSupplier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideCodec;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.internal.core.residue.AbstractResidueSequence;

final class DefaultNucleotideSequence
extends AbstractResidueSequence<Nucleotide, NucleotideSequence, NucleotideSequenceBuilder>
implements NucleotideSequence {
    private static final long serialVersionUID = 7441128261035593978L;
    private final transient NucleotideCodec codec;
    private final transient byte[] data;
    private transient int hash;
    private transient boolean isDna;
    private transient boolean changeTs;

    DefaultNucleotideSequence(NucleotideCodec codec, byte[] data, boolean hasUracil, boolean changeTs) {
        this.codec = codec;
        this.data = data;
        this.isDna = !hasUracil;
        this.changeTs = changeTs;
    }

    @Override
    public boolean isDna() {
        return this.isDna;
    }

    @Override
    public int getNumberOfGapsUntil(int gappedValidRangeIndex) {
        return this.codec.getNumberOfGapsUntil(this.data, gappedValidRangeIndex);
    }

    @Override
    public Range toUngappedRange(Range gappedRange) {
        this.ensureRangeWithinSequence(gappedRange, this::getLength);
        return this.codec.toUngappedRange(this.data, gappedRange);
    }

    @Override
    public Range toGappedRange(Range ungappedRange) {
        this.ensureRangeWithinSequence(ungappedRange, this::getUngappedLength);
        return this.codec.toGappedRange(this.data, ungappedRange);
    }

    @Override
    public Stream<Range> findMatches(Pattern pattern) {
        return this.codec.matches(this.data, pattern);
    }

    @Override
    public Stream<Range> findMatches(Pattern pattern, Range subSequenceRange) {
        return this.codec.matches(this.data, pattern, subSequenceRange);
    }

    @Override
    public Stream<Range> findMatches(Pattern pattern, boolean nested) {
        return this.codec.matches(this.data, pattern, nested);
    }

    @Override
    public Stream<Range> findMatches(Pattern pattern, Range subSequenceRange, boolean nested) {
        return this.codec.matches(this.data, pattern, subSequenceRange, nested);
    }

    private void ensureRangeWithinSequence(Range gappedRange, LongSupplier lengthSupplier) {
        Objects.requireNonNull(gappedRange);
        long end = gappedRange.getEnd();
        long begin = gappedRange.getBegin();
        if (end < 0L || begin < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long length = lengthSupplier.getAsLong();
        if (end >= length || begin >= length) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public List<Integer> getGapOffsets() {
        return this.codec.getGapOffsets(this.data);
    }

    @Override
    public Nucleotide get(long index) {
        return (Nucleotide)this.codec.decode(this.data, index);
    }

    @Override
    public long getLength() {
        return this.codec.decodedLengthOf(this.data);
    }

    @Override
    public boolean isGap(int index) {
        return this.codec.isGap(this.data, index);
    }

    @Override
    public int hashCode() {
        long length = this.getLength();
        if (this.hash == 0 && length > 0L) {
            int prime = 31;
            int result = 1;
            Iterator<Nucleotide> iter = this.iterator();
            while (iter.hasNext()) {
                result = 31 * result + iter.next().hashCode();
            }
            this.hash = result;
        }
        return this.hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NucleotideSequence)) {
            return false;
        }
        NucleotideSequence other = (NucleotideSequence)obj;
        if (this.getLength() != other.getLength()) {
            return false;
        }
        Iterator<Nucleotide> iter = this.iterator();
        Iterator otherIter = other.iterator();
        while (iter.hasNext()) {
            if (iter.next().equals(otherIter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getNumberOfGaps() {
        return this.codec.getNumberOfGaps(this.data);
    }

    @Override
    public Iterator<Nucleotide> iterator() {
        return this.iteratorWrapper(this.codec.iterator(this.data));
    }

    @Override
    public Iterator<Nucleotide> iterator(Range range) {
        return this.iteratorWrapper(this.codec.iterator(this.data, range));
    }

    private Iterator<Nucleotide> iteratorWrapper(Iterator<Nucleotide> iter) {
        if (this.isDna || !this.changeTs) {
            return iter;
        }
        return IteratorUtil.map(iter, n -> n == Nucleotide.Thymine ? Nucleotide.Uracil : n);
    }

    private Object writeReplace() {
        return new DefaultNucleotideSequenceProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    @Override
    public NucleotideSequenceBuilder toBuilder() {
        return new NucleotideSequenceBuilder(this);
    }

    @Override
    public NucleotideSequenceBuilder toBuilder(Range range) {
        return new NucleotideSequenceBuilder(this, range);
    }

    @Override
    public NucleotideSequence asSubtype() {
        return this;
    }

    @Override
    public List<Range> getRangesOfNs() {
        return this.codec.getNRanges(this.data);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder((int)this.getLength());
        Iterator<Nucleotide> iter = this.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
        }
        return builder.toString();
    }

    private static final class DefaultNucleotideSequenceProxy
    implements Serializable {
        private static final long serialVersionUID = 6476363248864141050L;
        private final String bases;

        DefaultNucleotideSequenceProxy(DefaultNucleotideSequence seq) {
            this.bases = seq.toString();
        }

        private Object readResolve() {
            return new NucleotideSequenceBuilder(this.bases).build();
        }
    }
}

