/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.residue.nt;

import java.util.Collections;
import java.util.List;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.Ranges;
import org.jcvi.jillion.core.residue.nt.AbstractTwoBitEncodedNucleotideCodec;
import org.jcvi.jillion.core.residue.nt.Nucleotide;

final class AcgtnNucloetideCodec
extends AbstractTwoBitEncodedNucleotideCodec {
    public static final AcgtnNucloetideCodec INSTANCE = new AcgtnNucloetideCodec();

    private AcgtnNucloetideCodec() {
        super(Nucleotide.Unknown);
    }

    @Override
    public List<Integer> getGapOffsets(byte[] encodedGlyphs) {
        return Collections.emptyList();
    }

    @Override
    public Range toUngappedRange(byte[] encodedData, Range gappedRange) {
        this.ensureWithinSequence(encodedData, gappedRange);
        return gappedRange;
    }

    private void ensureWithinSequence(byte[] encodedData, Range gappedRange) {
        int length = this.decodedLengthOf(encodedData);
        if (gappedRange.getBegin() < 0L || gappedRange.getEnd() < 0L || (long)length < gappedRange.getEnd()) {
            throw new IndexOutOfBoundsException("range " + gappedRange + " is out of beyond the boundaries of seq with length " + length);
        }
    }

    @Override
    public Range toGappedRange(byte[] encodedData, Range ungappedRange) {
        this.ensureWithinSequence(encodedData, ungappedRange);
        return ungappedRange;
    }

    @Override
    public int getNumberOfGaps(byte[] encodedGlyphs) {
        return 0;
    }

    @Override
    public boolean isGap(byte[] encodedGlyphs, int gappedOffset) {
        return false;
    }

    @Override
    public long getUngappedLength(byte[] encodedGlyphs) {
        return this.decodedLengthOf(encodedGlyphs);
    }

    @Override
    public int getNumberOfGapsUntil(byte[] encodedGlyphs, int gappedOffset) {
        return 0;
    }

    @Override
    public int getUngappedOffsetFor(byte[] encodedGlyphs, int gappedOffset) {
        return gappedOffset;
    }

    @Override
    public int getGappedOffsetFor(byte[] encodedGlyphs, int ungappedOffset) {
        return ungappedOffset;
    }

    @Override
    public List<Range> getNRanges(byte[] encodedData) {
        return Ranges.asRanges(this.getSentinelOffsets(encodedData).toArray());
    }
}

