/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.residue.nt;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.jcvi.jillion.core.residue.nt.AbstractNucleotideCodec;
import org.jcvi.jillion.core.residue.nt.Nucleotide;

abstract class AbstractTwoBitEncodedNucleotideCodec
extends AbstractNucleotideCodec {
    private static final int ORDINAL_A = 12;
    private static final int ORDINAL_C = 13;
    private static final int ORDINAL_G = 14;
    private static final int ORDINAL_T = 15;

    @Override
    protected byte getByteFor(Nucleotide nuc) {
        int ordinal = nuc.ordinal();
        switch (ordinal) {
            case 12: {
                return 0;
            }
            case 13: {
                return 1;
            }
            case 14: {
                return 2;
            }
            case 15: {
                return 3;
            }
        }
        throw new IllegalArgumentException("only A,C,G,T supported : " + nuc);
    }

    @Override
    protected Nucleotide getGlyphFor(byte b) {
        switch (b) {
            case 0: {
                return Nucleotide.Adenine;
            }
            case 1: {
                return Nucleotide.Cytosine;
            }
            case 2: {
                return Nucleotide.Guanine;
            }
            case 3: {
                return Nucleotide.Thymine;
            }
        }
        throw new IllegalArgumentException("unknown encoded value : " + b);
    }

    @Override
    protected Nucleotide getNucleotide(byte encodedByte, int index) {
        int j = index % 4 << 1;
        return this.getGlyphFor((byte)(encodedByte >> j & 3));
    }

    @Override
    protected void encodeLastGroup(Iterator<Nucleotide> glyphs, ByteBuffer result, int offset) {
        byte b0 = this.getNextByte(glyphs);
        byte b1 = this.getNextByte(glyphs);
        byte b2 = this.getNextByte(glyphs);
        byte b3 = this.getNextByte(glyphs);
        result.put((byte)((b3 << 6 | b2 << 4 | b1 << 2 | b0) & 0xFF));
    }

    private byte getNextByte(Iterator<Nucleotide> glyphs) {
        return glyphs.hasNext() ? this.getSentienelByteFor(glyphs.next()) : (byte)0;
    }

    @Override
    protected void encodeCompleteGroup(Iterator<Nucleotide> glyphs, ByteBuffer result, int offset) {
        byte b0 = this.getSentienelByteFor(glyphs.next());
        byte b1 = this.getSentienelByteFor(glyphs.next());
        byte b2 = this.getSentienelByteFor(glyphs.next());
        byte b3 = this.getSentienelByteFor(glyphs.next());
        result.put((byte)((b3 << 6 | b2 << 4 | b1 << 2 | b0) & 0xFF));
    }

    protected AbstractTwoBitEncodedNucleotideCodec(Nucleotide sententialBase) {
        super(sententialBase);
    }

    @Override
    protected int getNucleotidesPerGroup() {
        return 4;
    }
}

