/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.residue.nt;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideCodec;
import org.jcvi.jillion.core.util.iter.SingleElementIterator;
import org.jcvi.jillion.internal.core.io.ValueSizeStrategy;
import org.jcvi.jillion.internal.core.util.GrowableIntArray;

abstract class AbstractNucleotideCodec
implements NucleotideCodec {
    private static final int END_OF_ITER = Integer.MIN_VALUE;
    private static final ValueSizeStrategy[] VALUE_SIZE_STRATEGIES = ValueSizeStrategy.values();
    private final Nucleotide sententialBase;

    protected AbstractNucleotideCodec(Nucleotide sententialBase) {
        this.sententialBase = sententialBase;
    }

    protected abstract int getNucleotidesPerGroup();

    protected abstract Nucleotide getNucleotide(byte var1, int var2);

    private ByteBuffer getBufferToComputeNumberOfGapsOnly(byte[] encodedBytes) {
        return ByteBuffer.wrap(encodedBytes, 0, Math.min(encodedBytes.length, 12));
    }

    @Override
    public int getUngappedOffsetFor(byte[] encodedGlyphs, int gappedOffset) {
        int numGaps = this.getNumberOfGapsUntil(encodedGlyphs, gappedOffset);
        return gappedOffset - numGaps;
    }

    @Override
    public int getGappedOffsetFor(byte[] encodedGlyphs, int ungappedOffset) {
        int currentOffset = ungappedOffset;
        ByteBuffer buf = ByteBuffer.wrap(encodedGlyphs);
        ValueSizeStrategy offsetStrategy = ValueSizeStrategy.values()[buf.get()];
        offsetStrategy.getNext(buf);
        ValueSizeStrategy sentinelStrategy = VALUE_SIZE_STRATEGIES[buf.get()];
        if (sentinelStrategy == ValueSizeStrategy.NONE) {
            return currentOffset;
        }
        int numberOfSentinels = sentinelStrategy.getNext(buf);
        int i = 0;
        while (i < numberOfSentinels) {
            int currentGapOffset = offsetStrategy.getNext(buf);
            if (currentGapOffset > currentOffset) {
                return currentOffset;
            }
            ++i;
            ++currentOffset;
        }
        return currentOffset;
    }

    @Override
    public boolean isGap(byte[] encodedGlyphs, int gappedOffset) {
        ByteBuffer buf = ByteBuffer.wrap(encodedGlyphs);
        ValueSizeStrategy offsetStrategy = ValueSizeStrategy.values()[buf.get()];
        offsetStrategy.getNext(buf);
        ValueSizeStrategy sentinelStrategy = VALUE_SIZE_STRATEGIES[buf.get()];
        if (sentinelStrategy == ValueSizeStrategy.NONE) {
            return false;
        }
        int numberOfSentinels = sentinelStrategy.getNext(buf);
        int firstGapOffset = offsetStrategy.getNext(buf);
        if (firstGapOffset > gappedOffset) {
            return false;
        }
        if (firstGapOffset == gappedOffset) {
            return true;
        }
        int currentGapOffset = firstGapOffset;
        for (int i = 1; i < numberOfSentinels; ++i) {
            currentGapOffset = offsetStrategy.getNext(buf);
            if (currentGapOffset == gappedOffset) {
                return true;
            }
            if (currentGapOffset <= gappedOffset) continue;
            return false;
        }
        return false;
    }

    @Override
    public long getUngappedLength(byte[] encodedGlyphs) {
        ByteBuffer buf = this.getBufferToComputeNumberOfGapsOnly(encodedGlyphs);
        ValueSizeStrategy offsetStrategy = ValueSizeStrategy.values()[buf.get()];
        int length = offsetStrategy.getNext(buf);
        ValueSizeStrategy sentinelStrategy = ValueSizeStrategy.values()[buf.get()];
        if (sentinelStrategy == ValueSizeStrategy.NONE) {
            return length;
        }
        int numGaps = sentinelStrategy.getNext(buf);
        return length - numGaps;
    }

    @Override
    public long getLength(byte[] encodedData) {
        ByteBuffer buf = this.getBufferToComputeNumberOfGapsOnly(encodedData);
        ValueSizeStrategy offsetStrategy = ValueSizeStrategy.values()[buf.get()];
        return offsetStrategy.getNext(buf);
    }

    @Override
    public int getNumberOfGaps(byte[] encodedGlyphs) {
        ByteBuffer buf = this.getBufferToComputeNumberOfGapsOnly(encodedGlyphs);
        ValueSizeStrategy offsetStrategy = ValueSizeStrategy.values()[buf.get()];
        offsetStrategy.getNext(buf);
        ValueSizeStrategy sentinelStrategy = ValueSizeStrategy.values()[buf.get()];
        if (sentinelStrategy == ValueSizeStrategy.NONE) {
            return 0;
        }
        return sentinelStrategy.getNext(buf);
    }

    protected GrowableIntArray getSentinelOffsets(byte[] encodedGlyphs) {
        ByteBuffer buf = ByteBuffer.wrap(encodedGlyphs);
        ValueSizeStrategy offsetStrategy = ValueSizeStrategy.values()[buf.get()];
        offsetStrategy.getNext(buf);
        ValueSizeStrategy sentinelStrategy = VALUE_SIZE_STRATEGIES[buf.get()];
        if (sentinelStrategy == ValueSizeStrategy.NONE) {
            return new GrowableIntArray();
        }
        int numberOfSentinels = sentinelStrategy.getNext(buf);
        GrowableIntArray sentinelOffsets = new GrowableIntArray(numberOfSentinels);
        for (int i = 0; i < numberOfSentinels; ++i) {
            sentinelOffsets.append(offsetStrategy.getNext(buf));
        }
        return sentinelOffsets;
    }

    @Override
    public int getNumberOfGapsUntil(byte[] encodedGlyphs, int gappedOffset) {
        ByteBuffer buf = ByteBuffer.wrap(encodedGlyphs);
        ValueSizeStrategy offsetStrategy = ValueSizeStrategy.values()[buf.get()];
        offsetStrategy.getNext(buf);
        ValueSizeStrategy sentinelStrategy = VALUE_SIZE_STRATEGIES[buf.get()];
        if (sentinelStrategy == ValueSizeStrategy.NONE) {
            return 0;
        }
        int numberOfSentinels = sentinelStrategy.getNext(buf);
        for (int i = 0; i < numberOfSentinels; ++i) {
            int currentGapOffset = offsetStrategy.getNext(buf);
            if (currentGapOffset <= gappedOffset) continue;
            return i;
        }
        return numberOfSentinels;
    }

    @Override
    public Nucleotide decode(byte[] encodedGlyphs, long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException(String.format("offset %d can not be negative ", index));
        }
        ByteBuffer buf = ByteBuffer.wrap(encodedGlyphs);
        ValueSizeStrategy offsetStrategy = VALUE_SIZE_STRATEGIES[buf.get()];
        int length = offsetStrategy.getNext(buf);
        if (index >= (long)length) {
            throw new IndexOutOfBoundsException(String.format("offset %d is >= length (%d)", index, length));
        }
        if (this.isSentinelOffset(buf, offsetStrategy, (int)index)) {
            return this.sententialBase;
        }
        int currentPosition = buf.position();
        int bytesToSkip = (int)(index / (long)this.getNucleotidesPerGroup());
        buf.position(currentPosition + bytesToSkip);
        int indexIntoByte = (int)(index % (long)this.getNucleotidesPerGroup());
        return this.getNucleotide(buf.get(), indexIntoByte);
    }

    private boolean isSentinelOffset(ByteBuffer buf, ValueSizeStrategy offsetStrategy, int index) {
        ValueSizeStrategy sentinelStrategy = VALUE_SIZE_STRATEGIES[buf.get()];
        if (sentinelStrategy == ValueSizeStrategy.NONE) {
            return false;
        }
        int numberOfSentinels = sentinelStrategy.getNext(buf);
        int nextSentinelOffset = Integer.MIN_VALUE;
        for (int i = 0; i < numberOfSentinels; ++i) {
            nextSentinelOffset = offsetStrategy.getNext(buf);
            if (index != nextSentinelOffset) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[] encode(int numberOfNucleotides, int[] gapOffsets, Iterator<Nucleotide> nucleotides) {
        return this.encodeNucleotides(nucleotides, gapOffsets, numberOfNucleotides);
    }

    @Override
    public byte[] encode(Nucleotide nt) {
        int[] gapOffsets = nt.isGap() ? new int[]{0} : new int[]{};
        return this.encodeNucleotides(new SingleElementIterator<Nucleotide>(nt), gapOffsets, 1);
    }

    public int getNumberOfEncodedBytesFor(int totalLength, int numberOfSentinelValues) {
        int encodedBasesSize = this.computeHeaderlessEncodedSize(totalLength);
        ValueSizeStrategy numBasesSizeStrategy = ValueSizeStrategy.getStrategyFor(totalLength);
        ValueSizeStrategy sentinelSizeStrategy = numberOfSentinelValues == 0 ? ValueSizeStrategy.NONE : ValueSizeStrategy.getStrategyFor(numberOfSentinelValues);
        return AbstractNucleotideCodec.computeEncodedBufferSize(encodedBasesSize, numBasesSizeStrategy, numberOfSentinelValues, sentinelSizeStrategy);
    }

    private byte[] encodeNucleotides(Iterator<Nucleotide> iterator, int[] sentienelOffsetArray, int unEncodedSize) {
        int encodedBasesSize = this.computeHeaderlessEncodedSize(unEncodedSize);
        ByteBuffer encodedBases = ByteBuffer.allocate(encodedBasesSize);
        this.encodeAll(iterator, unEncodedSize, encodedBases);
        encodedBases.flip();
        ValueSizeStrategy numBasesSizeStrategy = ValueSizeStrategy.getStrategyFor(unEncodedSize);
        int numberOfSentinels = sentienelOffsetArray.length;
        ValueSizeStrategy sentinelSizeStrategy = numberOfSentinels == 0 ? ValueSizeStrategy.NONE : ValueSizeStrategy.getStrategyFor(numberOfSentinels);
        int bufferSize = AbstractNucleotideCodec.computeEncodedBufferSize(encodedBasesSize, numBasesSizeStrategy, numberOfSentinels, sentinelSizeStrategy);
        ByteBuffer result = ByteBuffer.allocate(bufferSize);
        result.put((byte)numBasesSizeStrategy.ordinal());
        numBasesSizeStrategy.put(result, unEncodedSize);
        result.put((byte)sentinelSizeStrategy.ordinal());
        if (sentinelSizeStrategy != ValueSizeStrategy.NONE) {
            sentinelSizeStrategy.put(result, numberOfSentinels);
            for (int i = 0; i < numberOfSentinels; ++i) {
                numBasesSizeStrategy.put(result, sentienelOffsetArray[i]);
            }
        }
        result.put(encodedBases);
        return result.array();
    }

    private static int computeEncodedBufferSize(int encodedBasesSize, ValueSizeStrategy numBasesSizeStrategy, int numberOfSentinels, ValueSizeStrategy sentinelSizeStrategy) {
        int bufferSize = 2 + numBasesSizeStrategy.getNumberOfBytesPerValue() + sentinelSizeStrategy.getNumberOfBytesPerValue() + numBasesSizeStrategy.getNumberOfBytesPerValue() * numberOfSentinels + encodedBasesSize;
        return bufferSize;
    }

    private void encodeAll(Iterator<Nucleotide> glyphs, int unEncodedSize, ByteBuffer result) {
        int i;
        int groupSize = this.getNucleotidesPerGroup();
        for (i = 0; i < unEncodedSize - groupSize; i += groupSize) {
            this.encodeCompleteGroup(glyphs, result, i);
        }
        if (i < unEncodedSize) {
            this.encodeLastGroup(glyphs, result, i);
        }
    }

    protected int computeHeaderlessEncodedSize(int size) {
        return (size + 3) / this.getNucleotidesPerGroup();
    }

    protected abstract byte getByteFor(Nucleotide var1);

    protected abstract Nucleotide getGlyphFor(byte var1);

    protected abstract void encodeCompleteGroup(Iterator<Nucleotide> var1, ByteBuffer var2, int var3);

    protected abstract void encodeLastGroup(Iterator<Nucleotide> var1, ByteBuffer var2, int var3);

    protected byte getSentienelByteFor(Nucleotide nucleotide) {
        if (nucleotide.equals(this.sententialBase)) {
            return 0;
        }
        return this.getByteFor(nucleotide);
    }

    @Override
    public int decodedLengthOf(byte[] encodedGlyphs) {
        ByteBuffer buf = ByteBuffer.wrap(encodedGlyphs);
        return VALUE_SIZE_STRATEGIES[buf.get()].getNext(buf);
    }

    @Override
    public Iterator<Nucleotide> iterator(byte[] encodedData) {
        return new IteratorImpl(encodedData);
    }

    @Override
    public Iterator<Nucleotide> iterator(byte[] encodedData, Range range) {
        return new IteratorImpl(encodedData, range);
    }

    @Override
    public String toString(byte[] encodedData) {
        IteratorImpl iter = (IteratorImpl)this.iterator(encodedData);
        StringBuilder builder = new StringBuilder(iter.getLength());
        while (iter.hasNext()) {
            builder.append(iter.next());
        }
        return builder.toString();
    }

    private final class IteratorImpl
    implements Iterator<Nucleotide> {
        private final int length;
        private final int[] sentinelArray;
        private final int numberOfBasesPerGroup;
        private int nextSentinel;
        private int currentOffset;
        private int sentinelIndex;
        private final byte[] encodedBytes;

        public IteratorImpl(byte[] encodedGlyphs) {
            this.numberOfBasesPerGroup = AbstractNucleotideCodec.this.getNucleotidesPerGroup();
            this.currentOffset = 0;
            this.sentinelIndex = 0;
            ByteBuffer buf = ByteBuffer.wrap(encodedGlyphs);
            ValueSizeStrategy offsetStrategy = VALUE_SIZE_STRATEGIES[buf.get()];
            this.length = offsetStrategy.getNext(buf);
            this.sentinelArray = this.parseSentinelOffsetsIteratorFrom(buf, offsetStrategy);
            this.encodedBytes = new byte[buf.remaining()];
            buf.get(this.encodedBytes);
            this.nextSentinel = this.getNextSentinel();
        }

        public IteratorImpl(byte[] encodedGlyphs, Range range) {
            this.numberOfBasesPerGroup = AbstractNucleotideCodec.this.getNucleotidesPerGroup();
            this.currentOffset = 0;
            this.sentinelIndex = 0;
            ByteBuffer buf = ByteBuffer.wrap(encodedGlyphs);
            ValueSizeStrategy offsetStrategy = VALUE_SIZE_STRATEGIES[buf.get()];
            int sequenceLength = offsetStrategy.getNext(buf);
            if (range.getBegin() < 0L || range.getEnd() >= (long)sequenceLength) {
                throw new IndexOutOfBoundsException("range " + range + " is out of range of sequence which is only " + new Range.Builder(sequenceLength).build());
            }
            this.length = (int)range.getEnd() + 1;
            this.sentinelArray = this.parseSentinelOffsetsIteratorFrom(buf, offsetStrategy);
            this.nextSentinel = this.getNextSentinel();
            this.currentOffset = (int)range.getBegin();
            while (this.nextSentinel != Integer.MIN_VALUE && this.nextSentinel < this.currentOffset) {
                this.nextSentinel = this.getNextSentinel();
            }
            this.encodedBytes = new byte[buf.remaining()];
            buf.get(this.encodedBytes);
        }

        public int getLength() {
            return this.length;
        }

        private int[] parseSentinelOffsetsIteratorFrom(ByteBuffer buf, ValueSizeStrategy offsetStrategy) {
            ValueSizeStrategy sentinelStrategy = VALUE_SIZE_STRATEGIES[buf.get()];
            if (sentinelStrategy == ValueSizeStrategy.NONE) {
                return new int[0];
            }
            int numberOfSentinels = sentinelStrategy.getNext(buf);
            int[] sentinelArray = new int[numberOfSentinels];
            for (int i = 0; i < numberOfSentinels; ++i) {
                sentinelArray[i] = offsetStrategy.getNext(buf);
            }
            return sentinelArray;
        }

        private int getNextSentinel() {
            if (this.sentinelIndex >= this.sentinelArray.length) {
                return Integer.MIN_VALUE;
            }
            return this.sentinelArray[this.sentinelIndex++];
        }

        @Override
        public boolean hasNext() {
            return this.currentOffset < this.length;
        }

        @Override
        public Nucleotide next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("no more elements");
            }
            if (this.nextSentinel == this.currentOffset) {
                this.nextSentinel = this.getNextSentinel();
                ++this.currentOffset;
                return AbstractNucleotideCodec.this.sententialBase;
            }
            int arrayoffset = this.currentOffset / this.numberOfBasesPerGroup;
            int groupIndex = this.currentOffset % this.numberOfBasesPerGroup;
            Nucleotide next = AbstractNucleotideCodec.this.getNucleotide(this.encodedBytes[arrayoffset], groupIndex);
            ++this.currentOffset;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("can not modify immutable sequence");
        }
    }
}

