/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.residue.aa;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.ResidueSequenceBuilder;
import org.jcvi.jillion.core.residue.aa.AminoAcid;
import org.jcvi.jillion.core.residue.aa.CompactProteinSequence;
import org.jcvi.jillion.core.residue.aa.ProteinSequence;
import org.jcvi.jillion.core.residue.aa.UngappedProteinSequence;
import org.jcvi.jillion.internal.core.util.GrowableByteArray;

public final class ProteinSequenceBuilder
implements ResidueSequenceBuilder<AminoAcid, ProteinSequence> {
    private static final AminoAcid[] AMINO_ACID_VALUES = AminoAcid.values();
    private static final byte GAP_ORDINAL = AminoAcid.Gap.getOrdinalAsByte();
    private static final int DEFAULT_CAPACITY = 20;
    private GrowableByteArray builder;
    private int numberOfGaps = 0;

    public ProteinSequenceBuilder() {
        this.builder = new GrowableByteArray(20);
    }

    public ProteinSequenceBuilder(int initialCapacity) {
        this.builder = new GrowableByteArray(initialCapacity);
    }

    public ProteinSequenceBuilder(CharSequence sequence) {
        this.builder = new GrowableByteArray(sequence.length());
        this.append(ProteinSequenceBuilder.parse(sequence.toString()));
    }

    public ProteinSequenceBuilder(ProteinSequence sequence) {
        this.builder = new GrowableByteArray((int)sequence.getLength());
        this.append((Iterable)sequence);
    }

    public ProteinSequenceBuilder(ProteinSequence sequence, Range range) {
        this.builder = new GrowableByteArray((int)range.getLength());
        Iterator iter = sequence.iterator(range);
        while (iter.hasNext()) {
            this.append((AminoAcid)iter.next());
        }
    }

    private ProteinSequenceBuilder(ProteinSequenceBuilder copy) {
        this.builder = copy.builder.copy();
    }

    private static List<AminoAcid> parse(String aminoAcids) {
        ArrayList<AminoAcid> result = new ArrayList<AminoAcid>(aminoAcids.length());
        for (int i = 0; i < aminoAcids.length(); ++i) {
            char charAt = aminoAcids.charAt(i);
            if (Character.isWhitespace(charAt)) continue;
            result.add(AminoAcid.parse(Character.valueOf(charAt)));
        }
        return result;
    }

    public ProteinSequenceBuilder append(AminoAcid residue) {
        if (residue == AminoAcid.Gap) {
            ++this.numberOfGaps;
        }
        this.builder.append(residue.getOrdinalAsByte());
        return this;
    }

    public ProteinSequenceBuilder clear() {
        this.numberOfGaps = 0;
        this.builder.clear();
        return this;
    }

    public ProteinSequenceBuilder append(Iterable<AminoAcid> sequence) {
        for (AminoAcid aa : sequence) {
            this.append(aa);
        }
        return this;
    }

    public ProteinSequenceBuilder append(ProteinSequenceBuilder otherBuilder) {
        this.builder.append(otherBuilder.builder.toArray());
        return this;
    }

    public ProteinSequenceBuilder append(String sequence) {
        return this.append(ProteinSequenceBuilder.parse(sequence));
    }

    public ProteinSequenceBuilder insert(int offset, String sequence) {
        List<AminoAcid> list = ProteinSequenceBuilder.parse(sequence);
        byte[] array = new byte[list.size()];
        int i = 0;
        for (AminoAcid aa : list) {
            if (aa == AminoAcid.Gap) {
                ++this.numberOfGaps;
            }
            array[i] = aa.getOrdinalAsByte();
            ++i;
        }
        this.builder.insert(offset, array);
        return this;
    }

    @Override
    public AminoAcid get(int offset) {
        return AMINO_ACID_VALUES[this.builder.get(offset)];
    }

    @Override
    public long getLength() {
        return this.builder.getCurrentLength();
    }

    @Override
    public long getUngappedLength() {
        return this.builder.getCurrentLength() - this.numberOfGaps;
    }

    public ProteinSequenceBuilder replace(int offset, AminoAcid replacement) {
        if (AMINO_ACID_VALUES[this.builder.get(offset)] == AminoAcid.Gap) {
            --this.numberOfGaps;
        }
        if (replacement == AminoAcid.Gap) {
            ++this.numberOfGaps;
        }
        this.builder.replace(offset, replacement.getOrdinalAsByte());
        return this;
    }

    @Override
    public ProteinSequenceBuilder delete(Range range) {
        for (AminoAcid aa : this.asList(range)) {
            if (aa != AminoAcid.Gap) continue;
            --this.numberOfGaps;
        }
        this.builder.remove(range);
        return this;
    }

    @Override
    public int getNumGaps() {
        return this.numberOfGaps;
    }

    public ProteinSequenceBuilder prepend(String sequence) {
        return this.insert(0, sequence);
    }

    public ProteinSequenceBuilder insert(int offset, Iterable<AminoAcid> sequence) {
        GrowableByteArray temp = new GrowableByteArray(20);
        for (AminoAcid aa : sequence) {
            if (aa == AminoAcid.Gap) {
                ++this.numberOfGaps;
            }
            temp.append(aa.getOrdinalAsByte());
        }
        this.builder.insert(offset, temp);
        return this;
    }

    public ProteinSequenceBuilder insert(int offset, ResidueSequenceBuilder<AminoAcid, ProteinSequence> otherBuilder) {
        return this.insert(offset, otherBuilder.toString());
    }

    public ProteinSequenceBuilder insert(int offset, AminoAcid base) {
        if (base == AminoAcid.Gap) {
            ++this.numberOfGaps;
        }
        this.builder.insert(offset, base.getOrdinalAsByte());
        return this;
    }

    public ProteinSequenceBuilder prepend(Iterable<AminoAcid> sequence) {
        return this.insert(0, (Iterable)sequence);
    }

    public ProteinSequenceBuilder prepend(ResidueSequenceBuilder<AminoAcid, ProteinSequence> otherBuilder) {
        return this.prepend(otherBuilder.toString());
    }

    @Override
    public ProteinSequence build() {
        return this.build(this.builder.toArray());
    }

    private AminoAcid[] convertFromBytes(byte[] array) {
        AminoAcid[] aas = new AminoAcid[array.length];
        for (int i = 0; i < array.length; ++i) {
            aas[i] = AMINO_ACID_VALUES[array[i]];
        }
        return aas;
    }

    private ProteinSequence build(byte[] seqToBuild) {
        AminoAcid[] asList = this.convertFromBytes(seqToBuild);
        if (this.numberOfGaps > 0 && this.hasGaps(asList)) {
            return new CompactProteinSequence(asList);
        }
        return new UngappedProteinSequence(asList);
    }

    private boolean hasGaps(AminoAcid[] asArray) {
        for (AminoAcid aa : asArray) {
            if (aa != AminoAcid.Gap) continue;
            return true;
        }
        return false;
    }

    private List<AminoAcid> asList(Range range) {
        ProteinSequence s = this.build();
        ArrayList<AminoAcid> list = new ArrayList<AminoAcid>((int)range.getLength());
        Iterator iter = s.iterator(range);
        while (iter.hasNext()) {
            list.add((AminoAcid)iter.next());
        }
        return list;
    }

    @Override
    public ProteinSequenceBuilder trim(Range range) {
        Range intersection = range.intersection(Range.ofLength(this.getLength()));
        this.builder = this.builder.subArray(intersection);
        this.numberOfGaps = this.builder.getCount(GAP_ORDINAL);
        return this;
    }

    @Override
    public ProteinSequenceBuilder copy() {
        return new ProteinSequenceBuilder(this);
    }

    @Override
    public ProteinSequenceBuilder reverse() {
        this.builder.reverse();
        return this;
    }

    public ProteinSequenceBuilder ungap() {
        ProteinSequence list = this.build(this.builder.toArray());
        if (list.getNumberOfGaps() != 0) {
            List<Integer> gapOffsets = list.getGapOffsets();
            for (int i = gapOffsets.size() - 1; i >= 0; --i) {
                this.builder.remove(gapOffsets.get(i));
            }
        }
        this.numberOfGaps = 0;
        return this;
    }

    @Override
    public String toString() {
        byte[] array = this.builder.toArray();
        StringBuilder stringBuilder = new StringBuilder(array.length);
        AminoAcid[] values = AminoAcid.values();
        for (int i = 0; i < array.length; ++i) {
            stringBuilder.append(values[array[i]]);
        }
        return stringBuilder.toString();
    }

    @Override
    public Iterator<AminoAcid> iterator() {
        return new IteratorImpl();
    }

    public ProteinSequenceBuilder turnOffDataCompression(boolean turnOffDataCompression) {
        return this;
    }

    private class IteratorImpl
    implements Iterator<AminoAcid> {
        private int currentOffset = 0;

        private IteratorImpl() {
        }

        @Override
        public boolean hasNext() {
            return this.currentOffset < ProteinSequenceBuilder.this.builder.getCurrentLength();
        }

        @Override
        public AminoAcid next() {
            AminoAcid next = AMINO_ACID_VALUES[ProteinSequenceBuilder.this.builder.get(this.currentOffset)];
            ++this.currentOffset;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

