/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.residue.aa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jcvi.jillion.core.residue.Frame;
import org.jcvi.jillion.core.residue.aa.AminoAcid;
import org.jcvi.jillion.core.residue.aa.Codon;
import org.jcvi.jillion.core.residue.aa.ProteinSequence;
import org.jcvi.jillion.core.residue.aa.ProteinSequenceBuilder;
import org.jcvi.jillion.core.residue.aa.TranslationTable;
import org.jcvi.jillion.core.residue.aa.TranslationVisitor;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.Triplet;
import org.jcvi.jillion.core.util.MapUtil;

public enum IupacTranslationTables implements TranslationTable
{
    STANDARD(1),
    VERTEBRATE_MITOCHONDRIAL(2){

        @Override
        protected void updateTable(Map<Triplet, Codon> map) {
            this.insertIntoTable('A', 'G', 'A', AminoAcid.STOP);
            this.insertIntoTable('A', 'G', 'G', AminoAcid.STOP);
            this.insertIntoTable('A', 'G', 'R', AminoAcid.STOP);
            this.insertIntoTable('A', 'T', 'A', AminoAcid.Methionine, true);
            this.insertIntoTable('A', 'T', 'R', AminoAcid.Methionine, true);
            this.insertIntoTable('T', 'G', 'A', AminoAcid.Tryptophan);
            this.insertIntoTable('T', 'G', 'R', AminoAcid.Tryptophan);
        }
    }
    ,
    YEAST_MITOCHONDRIAL(3){

        @Override
        protected void updateTable(Map<Triplet, Codon> map) {
            this.insertIntoTable('A', 'T', 'A', AminoAcid.Methionine, true);
            this.insertIntoTable('A', 'T', 'R', AminoAcid.Methionine, true);
            this.insertIntoTable('C', 'T', 'A', AminoAcid.Threonine);
            this.insertIntoTable('C', 'T', 'C', AminoAcid.Threonine);
            this.insertIntoTable('C', 'T', 'G', AminoAcid.Threonine);
            this.insertIntoTable('C', 'T', 'T', AminoAcid.Threonine);
            this.insertIntoTable('C', 'T', 'M', AminoAcid.Threonine);
            this.insertIntoTable('C', 'T', 'R', AminoAcid.Threonine);
            this.insertIntoTable('C', 'T', 'W', AminoAcid.Threonine);
            this.insertIntoTable('C', 'T', 'S', AminoAcid.Threonine);
            this.insertIntoTable('C', 'T', 'Y', AminoAcid.Threonine);
            this.insertIntoTable('C', 'T', 'K', AminoAcid.Threonine);
            this.insertIntoTable('C', 'T', 'V', AminoAcid.Threonine);
            this.insertIntoTable('C', 'T', 'H', AminoAcid.Threonine);
            this.insertIntoTable('C', 'T', 'D', AminoAcid.Threonine);
            this.insertIntoTable('C', 'T', 'B', AminoAcid.Threonine);
            this.insertIntoTable('C', 'T', 'N', AminoAcid.Threonine);
            this.insertIntoTable('T', 'G', 'A', AminoAcid.Tryptophan);
            this.removeFromTable('C', 'G', 'A');
            this.removeFromTable('C', 'G', 'C');
            this.removeFromTable('C', 'G', 'R');
        }
    }
    ,
    MOLD_PROTOZOAN_COELENTERATE_MITOCHONDRIAL_AND_MYCOPLASMA_SPIROPLAMSA(4){

        @Override
        protected void updateTable(Map<Triplet, Codon> map) {
            this.insertIntoTable('T', 'G', 'A', AminoAcid.Tryptophan);
            this.insertIntoTable('T', 'G', 'R', AminoAcid.Tryptophan);
        }
    }
    ,
    CILIATE_DASYCLADACEAN_AND_HEXAMITA(6){

        @Override
        protected void updateTable(Map<Triplet, Codon> map) {
            this.insertIntoTable('T', 'A', 'A', AminoAcid.Glutamine);
            this.insertIntoTable('T', 'A', 'G', AminoAcid.Glutamine);
            this.insertIntoTable('T', 'A', 'R', AminoAcid.Glutamine);
            this.insertIntoTable('T', 'T', 'G', AminoAcid.Leucine);
            this.insertIntoTable('C', 'T', 'G', AminoAcid.Leucine);
        }
    }
    ,
    BACTERIAL_ARCHAEL_AND_PLANT_PLASTID(11){

        @Override
        protected void updateTable(Map<Triplet, Codon> map) {
            this.insertIntoTable('G', 'T', 'G', AminoAcid.Valine, true);
            this.insertIntoTable('A', 'T', 'T', AminoAcid.Isoleucine, true);
            this.insertIntoTable('A', 'T', 'C', AminoAcid.Isoleucine, true);
            this.insertIntoTable('A', 'T', 'A', AminoAcid.Isoleucine, true);
            this.insertIntoTable('A', 'T', 'G', AminoAcid.Isoleucine, true);
            this.insertIntoTable('A', 'T', 'M', AminoAcid.Isoleucine, true);
            this.insertIntoTable('A', 'T', 'R', AminoAcid.Isoleucine, true);
            this.insertIntoTable('A', 'T', 'W', AminoAcid.Isoleucine, true);
            this.insertIntoTable('A', 'T', 'S', AminoAcid.Isoleucine, true);
            this.insertIntoTable('A', 'T', 'Y', AminoAcid.Isoleucine, true);
            this.insertIntoTable('A', 'T', 'K', AminoAcid.Isoleucine, true);
            this.insertIntoTable('A', 'T', 'V', AminoAcid.Isoleucine, true);
            this.insertIntoTable('A', 'T', 'H', AminoAcid.Isoleucine, true);
            this.insertIntoTable('A', 'T', 'D', AminoAcid.Isoleucine, true);
            this.insertIntoTable('A', 'T', 'B', AminoAcid.Isoleucine, true);
            this.insertIntoTable('A', 'T', 'N', AminoAcid.Isoleucine, true);
        }
    };

    private static final Map<Integer, IupacTranslationTables> TABLES;
    private final Map<Triplet, Codon> map = new HashMap<Triplet, Codon>(MapUtil.computeMinHashMapSizeWithoutRehashing(200L));
    private final byte tableNumber;

    private IupacTranslationTables(int tableNumber) {
        this.initialzeTable();
        this.updateTable(this.map);
        this.tableNumber = (byte)tableNumber;
    }

    protected void removeFromTable(char base1, char base2, char base3) {
        Triplet triplet = Triplet.create(base1, base2, base3);
        this.map.remove(triplet);
    }

    protected void insertIntoTable(char base1, char base2, char base3, AminoAcid aa) {
        this.insertIntoTable(base1, base2, base3, aa, false);
    }

    protected void insertIntoTable(char base1, char base2, char base3, AminoAcid aa, boolean isStart) {
        Triplet triplet = Triplet.create(base1, base2, base3);
        Codon.Builder builder = new Codon.Builder(triplet, aa);
        if (aa == AminoAcid.STOP) {
            builder.isStop(true);
        }
        if (isStart) {
            builder.isStart(true);
        }
        this.map.put(triplet, builder.build());
    }

    private void initialzeTable() {
        char[] aas = "FFFLLLSSSSSSSSSSSSSSSYYY***CCC*WLLLLLLLLPPPPPPPPPPPPPPPHHHQQQRRRRRRRRRRRRRRRIIIIIIIMTTTTTTTTTTTTTTTNNNKKKSSSRRRVVVVVVVVVVVVVVVAAAAAAAAAAAAAAADDDEEEGGGGGGGGGGGGGGG".toCharArray();
        char[] starts = "----M----------------------------------M-------------------------------------------M------------------------------------------------------------------------------".toCharArray();
        char[] base1 = "TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG".toCharArray();
        char[] base2 = "TTTTTTCCCCCCCCCCCCCCCAAAAAAGGGGGTTTTTTTTCCCCCCCCCCCCCCCAAAAAAGGGGGGGGGGGGGGGTTTTTTTTCCCCCCCCCCCCCCCAAAAAAGGGGGGTTTTTTTTTTTTTTTCCCCCCCCCCCCCCCAAAAAAGGGGGGGGGGGGGGG".toCharArray();
        char[] base3 = "TCYAGRTCAGMRWSYKVHDBNTCYAGRTCYAGTCAMWYHGTCAGMRWSYKVHDBNTCYAGRTCAGMRWSYKVHDBNTCAMWYHGTCAGMRWSYKVHDBNTCYAGRTCYAGRTCAGMRWSYKVHDBNTCAGMRWSYKVHDBNTCYAGRTCAGMRWSYKVHDBN".toCharArray();
        for (int i = 0; i < aas.length; ++i) {
            this.insertIntoTable(base1[i], base2[i], base3[i], AminoAcid.parse(Character.valueOf(aas[i])), starts[i] == 'M');
        }
        this.insertIntoTable('-', '-', '-', AminoAcid.Gap, false);
    }

    @Override
    public ProteinSequence translate(NucleotideSequence sequence) {
        return this.translate(sequence, Frame.ONE, true);
    }

    @Override
    public ProteinSequence translate(NucleotideSequence sequence, boolean substituteStart) {
        return this.translate(sequence, Frame.ONE, substituteStart);
    }

    @Override
    public ProteinSequence translate(NucleotideSequence sequence, Frame frame) {
        return this.translate(sequence, frame, true);
    }

    @Override
    public ProteinSequence translate(NucleotideSequence sequence, Frame frame, boolean substituteStart) {
        return this.translate(sequence, frame, (int)sequence.getLength(), substituteStart);
    }

    @Override
    public ProteinSequence translate(NucleotideSequence sequence, Frame frame, int length, boolean substituteStart) {
        if (sequence == null) {
            throw new NullPointerException("sequence can not be null");
        }
        if (frame == null) {
            throw new NullPointerException("frame can not be null");
        }
        ProteinSequenceBuilder builder = new ProteinSequenceBuilder(length / 3);
        Iterator<Triplet> iter = frame.asTriplets(sequence);
        boolean seenStart = !substituteStart;
        for (long currentOffset = 0L; iter.hasNext() && currentOffset < (long)length; currentOffset += 3L) {
            Triplet triplet = iter.next();
            if (triplet == null) continue;
            Codon codon = this.translate(triplet);
            if (codon.isStart() && !seenStart) {
                seenStart = true;
                builder.append(AminoAcid.Methionine);
                continue;
            }
            builder.append(codon.getAminoAcid());
        }
        return builder.build();
    }

    @Override
    public void translate(NucleotideSequence sequence, Frame frame, TranslationVisitor visitor) {
        if (sequence == null) {
            throw new NullPointerException("sequence can not be null");
        }
        if (frame == null) {
            throw new NullPointerException("frame can not be null");
        }
        if (visitor == null) {
            throw new NullPointerException("frame can not be null");
        }
        Iterator<Triplet> iter = frame.asTriplets(sequence);
        boolean seenStart = false;
        long currentOffset = frame.ordinal();
        while (iter.hasNext()) {
            Triplet triplet = iter.next();
            if (triplet != null) {
                Enum result;
                Codon codon = this.translate(triplet);
                if (codon.isStart()) {
                    result = visitor.foundStart(currentOffset, codon);
                    if (result == TranslationVisitor.FoundStartResult.STOP) break;
                    seenStart = result != TranslationVisitor.FoundStartResult.FIND_ADDITIONAL_STARTS;
                } else if (seenStart) {
                    if (codon.isStop()) {
                        result = visitor.foundStop(currentOffset, codon);
                        if (result == TranslationVisitor.FoundStopResult.STOP) {
                            break;
                        }
                    } else {
                        visitor.visitCodon(currentOffset, codon);
                    }
                }
            }
            currentOffset += 3L;
        }
        visitor.end();
    }

    @Override
    public ProteinSequence translate(NucleotideSequence sequence, Frame frame, int length) {
        return this.translate(sequence, frame, length, true);
    }

    protected void updateTable(Map<Triplet, Codon> map) {
    }

    private Codon translate(Triplet triplet) {
        return this.map.computeIfAbsent(triplet, t -> new Codon.Builder((Triplet)t, AminoAcid.Unknown_Amino_Acid).build());
    }

    public int getTableNumber() {
        return this.tableNumber;
    }

    public static TranslationTable getTableByTableNumber(int tableNumber) {
        TranslationTable table = TABLES.get(tableNumber);
        if (table == null) {
            throw new IllegalArgumentException("unknown table number " + tableNumber);
        }
        return table;
    }

    @Override
    public Map<Frame, List<Long>> findStops(NucleotideSequence sequence) {
        if (sequence == null) {
            throw new NullPointerException("sequence can not be null");
        }
        HashMap<Frame, List<Long>> stops = new HashMap<Frame, List<Long>>();
        long frameOffset = 0L;
        for (Frame frame : Frame.forwardFrames()) {
            ArrayList<Long> stopCoordinates = new ArrayList<Long>();
            stops.put(frame, stopCoordinates);
            long index = frameOffset;
            Iterator<Triplet> tripletIter = frame.asTriplets(sequence);
            while (tripletIter.hasNext()) {
                if (this.translate(tripletIter.next()).isStop()) {
                    stopCoordinates.add(index);
                }
                index += 3L;
            }
            ++frameOffset;
        }
        return stops;
    }

    static {
        TABLES = new HashMap<Integer, IupacTranslationTables>(MapUtil.computeMinHashMapSizeWithoutRehashing(25L));
        for (IupacTranslationTables table : IupacTranslationTables.values()) {
            TABLES.put(table.getTableNumber(), table);
        }
    }
}

