/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.residue.aa;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.aa.AminoAcid;
import org.jcvi.jillion.core.residue.aa.AminoAcidCodec;

enum CompactProteinSequenceCodec implements AminoAcidCodec
{
    INSTANCE;

    private static final int BITS_PER_AA = 5;

    @Override
    public byte[] encode(AminoAcid[] aas) {
        int numberOfAminoAcids = aas.length;
        int numBits = numberOfAminoAcids * 5;
        BitSet bits = new BitSet(numBits);
        int offset = 0;
        for (AminoAcid aa : aas) {
            byte ordinal = aa.getOrdinalAsByte();
            for (int i = 0; i < 5; ++i) {
                if ((ordinal & 1 << i) != 0) {
                    bits.set(offset);
                }
                ++offset;
            }
        }
        byte[] encodedData = IOUtil.toByteArray(bits, numBits);
        ByteBuffer buf = ByteBuffer.allocate(4 + encodedData.length);
        buf.putInt(numberOfAminoAcids);
        buf.put(encodedData);
        return buf.array();
    }

    protected AminoAcid getAminoAcidFor(BitSet subSet) {
        AminoAcid aa = subSet.isEmpty() ? AminoAcid.values()[0] : AminoAcid.values()[new BigInteger(IOUtil.toByteArray(subSet, 5)).intValue()];
        return aa;
    }

    @Override
    public AminoAcid decode(byte[] encodedGlyphs, long index) {
        byte[] tmp = Arrays.copyOfRange(encodedGlyphs, 4, encodedGlyphs.length);
        BitSet bits = IOUtil.toBitSet(tmp);
        int bitOffset = 5 * (int)index;
        BitSet subSet = bits.get(bitOffset, bitOffset + 5);
        return this.getAminoAcidFor(subSet);
    }

    @Override
    public int decodedLengthOf(byte[] encodedGlyphs) {
        ByteBuffer buf = ByteBuffer.wrap(encodedGlyphs);
        return buf.getInt();
    }
}

