/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.residue.aa;

import org.jcvi.jillion.core.residue.aa.AminoAcid;
import org.jcvi.jillion.core.residue.nt.Triplet;

public final class Codon {
    private final Triplet triplet;
    private final AminoAcid aminoAcid;
    private final boolean isStart;
    private final boolean isStop;

    private Codon(Triplet triplet, AminoAcid aminoAcid, boolean isStart, boolean isStop) {
        this.triplet = triplet;
        this.aminoAcid = aminoAcid;
        this.isStart = isStart;
        this.isStop = isStop;
    }

    public Triplet getTriplet() {
        return this.triplet;
    }

    public AminoAcid getAminoAcid() {
        return this.aminoAcid;
    }

    public boolean isStart() {
        return this.isStart;
    }

    public boolean isStop() {
        return this.isStop;
    }

    public static final class Builder {
        private final Triplet triplet;
        private final AminoAcid aminoAcid;
        private boolean isStart;
        private boolean isStop;

        public Builder(Triplet triplet, AminoAcid aminoAcid) {
            if (triplet == null) {
                throw new NullPointerException("triplet can not be null");
            }
            if (aminoAcid == null) {
                throw new NullPointerException("aminoAcid can not be null");
            }
            this.triplet = triplet;
            this.aminoAcid = aminoAcid;
        }

        public Builder isStop(boolean value) {
            this.isStop = value;
            return this;
        }

        public Builder isStart(boolean value) {
            this.isStart = value;
            return this;
        }

        public Codon build() {
            return new Codon(this.triplet, this.aminoAcid, this.isStart, this.isStop);
        }
    }
}

