/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.residue.aa;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jcvi.jillion.core.residue.Residue;
import org.jcvi.jillion.core.util.MapUtil;

public enum AminoAcid implements Residue
{
    Isoleucine("Isolucine", "Ile", Character.valueOf('I')),
    Leucine("Leucine", "Leu", Character.valueOf('L')),
    Lysine("Lysine", "Lys", Character.valueOf('K')),
    Methionine("Methionine", "Met", Character.valueOf('M')),
    Phenylalanine("Phenylalanine", "Phe", Character.valueOf('F')),
    Threonine("Threonine", "Thr", Character.valueOf('T')),
    Tryptophan("Tryptophan", "Trp", Character.valueOf('W')),
    Valine("Valine", "Val", Character.valueOf('V')),
    Cysteine("Cysteine", "Cys", Character.valueOf('C')),
    Glutamine("Glutamine", "Gln", Character.valueOf('Q')),
    Glycine("Glycine", "Gly", Character.valueOf('G')),
    Proline("Proline", "Pro", Character.valueOf('P')),
    Serine("Serine", "Ser", Character.valueOf('S')),
    Tyrosine("Tyrosine", "Tyr", Character.valueOf('Y')),
    Arginine("Arginine", "Arg", Character.valueOf('R')),
    Histidine("Histidine", "His", Character.valueOf('H')),
    Alanine("Alanine", "Ala", Character.valueOf('A')),
    Asparagine("Asparagine", "Asn", Character.valueOf('N')),
    Aspartic_Acid("Aspartic Acid", "Asp", Character.valueOf('D')),
    Glutamic_Acid("Glutamic Acid", "Glu", Character.valueOf('E')),
    Unknown_Amino_Acid("Unknown Amino Acid", "Unk", Character.valueOf('X')),
    Aspartate_or_Asparagine("Aspartate or Asparagine", "Asx", Character.valueOf('B')),
    Glutamate_or_Glutamine("Glutamate or Glutamine", "Glx", Character.valueOf('Z')),
    Selenocysteine("Selenocysteine", "Sec", Character.valueOf('U')),
    Pyrrolysine("Pyrrolysine", "Ply", Character.valueOf('O')),
    Gap("Gap", "---", Character.valueOf('-')){

        @Override
        public boolean isGap() {
            return true;
        }
    }
    ,
    STOP("Stop", "Stop", Character.valueOf('*'));

    private final Character abbreviation;
    private final String threeLetterAbbreviation;
    private final String name;
    private static final Map<String, AminoAcid> NAME_MAP;

    private AminoAcid(String name, String threeLetterAbbreviation, Character abbreviation) {
        this.name = name;
        this.threeLetterAbbreviation = threeLetterAbbreviation;
        this.abbreviation = abbreviation;
    }

    public static AminoAcid parse(Character aminoAcidAbbreviation) {
        return AminoAcid.parse(aminoAcidAbbreviation.toString());
    }

    public static AminoAcid parse(String aminoAcid) {
        AminoAcid result = NAME_MAP.get(aminoAcid.toUpperCase(Locale.US));
        if (result == null) {
            throw new IllegalArgumentException(String.format("%s is not a valid Amino Acid", aminoAcid));
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean isGap() {
        return false;
    }

    public String toString() {
        return this.getCharacter().toString();
    }

    @Override
    public Character getCharacter() {
        return this.abbreviation;
    }

    public String get3LetterAbbreviation() {
        return this.threeLetterAbbreviation;
    }

    public static String convertToString(List<AminoAcid> glyphs) {
        StringBuilder result = new StringBuilder();
        for (AminoAcid g : glyphs) {
            result.append(g.getCharacter());
        }
        return result.toString();
    }

    @Override
    public byte getOrdinalAsByte() {
        return (byte)this.ordinal();
    }

    public char asChar() {
        return this.abbreviation.charValue();
    }

    static {
        int mapSize = MapUtil.computeMinHashMapSizeWithoutRehashing(AminoAcid.values().length * 3);
        NAME_MAP = new HashMap<String, AminoAcid>(mapSize);
        for (AminoAcid aa : AminoAcid.values()) {
            NAME_MAP.put(aa.getName().toUpperCase(), aa);
            NAME_MAP.put(aa.get3LetterAbbreviation().toUpperCase(), aa);
            NAME_MAP.put(aa.getCharacter().toString().toUpperCase(), aa);
        }
    }
}

