/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.residue.aa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.Sequence;
import org.jcvi.jillion.core.residue.aa.AminoAcid;
import org.jcvi.jillion.core.residue.aa.AminoAcidCodec;
import org.jcvi.jillion.core.residue.aa.ProteinSequence;
import org.jcvi.jillion.core.residue.aa.ProteinSequenceBuilder;
import org.jcvi.jillion.internal.core.EncodedSequence;
import org.jcvi.jillion.internal.core.GlyphCodec;
import org.jcvi.jillion.internal.core.residue.AbstractResidueSequence;

abstract class AbstractProteinSequence
extends AbstractResidueSequence<AminoAcid, ProteinSequence, ProteinSequenceBuilder>
implements ProteinSequence {
    private static final long serialVersionUID = -8506764895478268009L;
    private final Sequence<AminoAcid> encodedAminoAcids;

    public AbstractProteinSequence(AminoAcid[] glyphs, AminoAcidCodec codec) {
        this.encodedAminoAcids = new EncodedSequence<AminoAcid>((GlyphCodec)codec, codec.encode(glyphs)){

            public ProteinSequenceBuilder toBuilder() {
                return new ProteinSequenceBuilder(AbstractProteinSequence.this);
            }
        };
    }

    @Override
    public AminoAcid get(long index) {
        return this.encodedAminoAcids.get(index);
    }

    @Override
    public long getLength() {
        return this.encodedAminoAcids.getLength();
    }

    @Override
    public Iterator<AminoAcid> iterator() {
        return this.encodedAminoAcids.iterator();
    }

    @Override
    public ProteinSequence asSubtype() {
        return this;
    }

    @Override
    public Iterator<AminoAcid> iterator(Range range) {
        return this.encodedAminoAcids.iterator(range);
    }

    @Override
    public List<Integer> getGapOffsets() {
        Iterator<AminoAcid> iter = this.iterator();
        int i = 0;
        ArrayList<Integer> gapOffsets = new ArrayList<Integer>();
        while (iter.hasNext()) {
            if (iter.next() == AminoAcid.Gap) {
                gapOffsets.add(i);
            }
            ++i;
        }
        return gapOffsets;
    }

    @Override
    public int getNumberOfGaps() {
        Iterator<AminoAcid> iter = this.iterator();
        int count = 0;
        while (iter.hasNext()) {
            if (iter.next() != AminoAcid.Gap) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isGap(int gappedOffset) {
        return this.encodedAminoAcids.get(gappedOffset) == AminoAcid.Gap;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder((int)this.getLength());
        for (AminoAcid aa : this) {
            builder.append(aa.asChar());
        }
        return builder.toString();
    }

    @Override
    public ProteinSequenceBuilder toBuilder() {
        return new ProteinSequenceBuilder(this);
    }

    @Override
    public ProteinSequenceBuilder toBuilder(Range range) {
        return new ProteinSequenceBuilder(this, range);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.encodedAminoAcids.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProteinSequence)) {
            return false;
        }
        ProteinSequence other = (ProteinSequence)obj;
        return this.toString().equals(other.toString());
    }

    protected Object writeReplace() {
        return new ProteinSequenceProxy(this);
    }

    private static final class ProteinSequenceProxy
    implements Serializable {
        private static final long serialVersionUID = -8473861196950222580L;
        private final String seq;

        ProteinSequenceProxy(ProteinSequence s) {
            this.seq = s.toString();
        }

        private Object readResolve() {
            return new ProteinSequenceBuilder(this.seq).build();
        }
    }
}

