/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.residue;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.Sequence;
import org.jcvi.jillion.core.residue.Kmer;
import org.jcvi.jillion.core.residue.KmerSpliterator;
import org.jcvi.jillion.core.residue.Residue;
import org.jcvi.jillion.core.residue.ResidueSequenceBuilder;

public interface ResidueSequence<R extends Residue, T extends ResidueSequence<R, T, B>, B extends ResidueSequenceBuilder<R, T>>
extends Sequence<R> {
    public List<Integer> getGapOffsets();

    public int getNumberOfGaps();

    public boolean isGap(int var1);

    public long getUngappedLength();

    public int getNumberOfGapsUntil(int var1);

    public int getUngappedOffsetFor(int var1);

    public int getGappedOffsetFor(int var1);

    default public Range toUngappedRange(Range gappedRange) {
        if (gappedRange == null) {
            throw new NullPointerException("gappedRange can not be null");
        }
        return Range.of(this.getUngappedOffsetFor((int)gappedRange.getBegin()), (long)this.getUngappedOffsetFor((int)gappedRange.getEnd()));
    }

    default public Range toGappedRange(Range ungappedRange) {
        if (ungappedRange == null) {
            throw new NullPointerException("ungappedRange can not be null");
        }
        return Range.of(this.getGappedOffsetFor((int)ungappedRange.getBegin()), (long)this.getGappedOffsetFor((int)ungappedRange.getEnd()));
    }

    public String toString();

    @Override
    public boolean equals(Object var1);

    default public boolean isEqualToIgnoringGaps(ResidueSequence<? extends R, T, B> other) {
        if (other == null) {
            return false;
        }
        if (this.getUngappedLength() != other.getUngappedLength()) {
            return false;
        }
        Iterator iter = this.iterator();
        Iterator otherIter = other.iterator();
        while (iter.hasNext()) {
            Residue nextNonGap;
            while ((nextNonGap = (Residue)iter.next()).isGap() && iter.hasNext()) {
            }
            Residue nextOtherNonGap = null;
            if (nextNonGap.isGap()) continue;
            while ((nextOtherNonGap = (Residue)otherIter.next()).isGap() && otherIter.hasNext()) {
            }
            if (nextNonGap.equals(nextOtherNonGap)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode();

    public B toBuilder();

    public B toBuilder(Range var1);

    public B newEmptyBuilder();

    public B newEmptyBuilder(int var1);

    public T asSubtype();

    default public Stream<Kmer<T>> kmers(int k) {
        return this.kmers(k, Range.ofLength(this.getLength()));
    }

    default public Stream<Kmer<T>> kmers(int k, Range range) {
        return StreamSupport.stream(new KmerSpliterator(k, this.asSubtype(), range), false);
    }
}

