/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.residue;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Spliterators;
import java.util.function.Consumer;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.Kmer;
import org.jcvi.jillion.core.residue.Residue;
import org.jcvi.jillion.core.residue.ResidueSequence;
import org.jcvi.jillion.core.residue.ResidueSequenceBuilder;

class KmerSpliterator<R extends Residue, S extends ResidueSequence<R, S, B>, B extends ResidueSequenceBuilder<R, S>>
extends Spliterators.AbstractSpliterator<Kmer<S>> {
    private LinkedList<ResidueSequenceBuilder<R, S>> builders = new LinkedList();
    private long counter;
    private final Iterator<R> iter;
    private final int k;
    private final S sequence;

    public KmerSpliterator(int k, S residueSequence, Range range) {
        super(residueSequence.getLength() - (long)k + 1L, 0);
        this.k = k;
        this.counter = range.getBegin();
        this.sequence = residueSequence;
        this.iter = residueSequence.iterator(range);
        if (residueSequence.getLength() >= (long)k) {
            for (int i = 0; i < k; ++i) {
                this.addNextBase();
            }
        }
    }

    private void addNextBase() {
        if (this.iter.hasNext()) {
            Residue n = (Residue)this.iter.next();
            this.builders.addLast(this.sequence.newEmptyBuilder(this.k).turnOffDataCompression(true));
            this.builders.forEach(b -> b.append(n));
        } else if (!this.builders.isEmpty()) {
            ResidueSequenceBuilder<R, S> head = this.builders.pop();
            this.builders.clear();
            if (head.getLength() == (long)this.k) {
                this.builders.add(head);
            }
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super Kmer<S>> action) {
        if (this.builders.isEmpty()) {
            return false;
        }
        action.accept(new Kmer<ResidueSequence>(this.counter++, (ResidueSequence)this.builders.pop().build()));
        this.addNextBase();
        return !this.builders.isEmpty();
    }
}

