/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.residue;

import java.util.Objects;
import org.jcvi.jillion.core.residue.ResidueSequence;

public class Kmer<T extends ResidueSequence<?, ?, ?>> {
    private final T value;
    private final long offset;

    public Kmer(long offset, T value) {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset can not be negative : " + offset);
        }
        this.offset = offset;
        this.value = (ResidueSequence)Objects.requireNonNull(value);
    }

    public T getValue() {
        return this.value;
    }

    public long getOffset() {
        return this.offset;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public String toString() {
        return "Kmer [value=" + this.value + ", offset=" + this.offset + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Kmer)) {
            return false;
        }
        Kmer other = (Kmer)obj;
        if (this.offset != other.offset) {
            return false;
        }
        return this.value.equals(other.value);
    }
}

