/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.residue;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.Triplet;
import org.jcvi.jillion.core.util.iter.IteratorUtil;

public enum Frame {
    ONE(1),
    TWO(2),
    THREE(3),
    NEGATIVE_ONE(-1){

        @Override
        public boolean onReverseStrand() {
            return true;
        }
    }
    ,
    NEGATIVE_TWO(-2){

        @Override
        public boolean onReverseStrand() {
            return true;
        }
    }
    ,
    NEGATIVE_THREE(-3){

        @Override
        public boolean onReverseStrand() {
            return true;
        }
    };

    private int frame;
    private static final Frame[] VALUES;
    private static final ArrayList<Frame> FORWARDS;
    private static final ArrayList<Frame> REVERSE;

    public final int getFrame() {
        return this.frame;
    }

    private Frame(int frame) {
        this.frame = frame;
    }

    public Frame shift(int amount) {
        if (amount < 1) {
            throw new IllegalArgumentException("amount must be positive");
        }
        int shift = amount % 3;
        Iterator rollOverIter = this.ordinal() < 3 ? IteratorUtil.rollover(FORWARDS, this.ordinal() + 1) : IteratorUtil.rollover(REVERSE, this.ordinal() - 2);
        Frame f = this;
        for (int i = 0; i < shift; ++i) {
            f = (Frame)((Object)rollOverIter.next());
        }
        return f;
    }

    public static Frame parseFrame(int frame) {
        for (Frame f : Frame.values()) {
            if (f.frame != frame) continue;
            return f;
        }
        throw new IllegalArgumentException("unable to parse frame " + frame);
    }

    public static List<Frame> forwardFrames() {
        return FORWARDS;
    }

    public static List<Frame> reverseFrames() {
        return REVERSE;
    }

    public boolean onReverseStrand() {
        return false;
    }

    public Frame getOppositeFrame() {
        return VALUES[(this.ordinal() + 3) % VALUES.length];
    }

    public Iterator<Triplet> asTriplets(NucleotideSequence sequence) {
        final Iterator<Nucleotide> iter = this.handleFrame(sequence, this);
        return new Iterator<Triplet>(){
            Triplet next;
            {
                this.next = Frame.this.getNextTriplet(iter);
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Triplet next() {
                if (!this.hasNext()) {
                    throw new NullPointerException();
                }
                Triplet ret = this.next;
                this.next = Frame.this.getNextTriplet(iter);
                return ret;
            }
        };
    }

    private Triplet getNextTriplet(Iterator<Nucleotide> iter) {
        Nucleotide first = this.getNextNucleotide(iter);
        Nucleotide second = this.getNextNucleotide(iter);
        Nucleotide third = this.getNextNucleotide(iter);
        if (first == null || second == null || third == null) {
            return null;
        }
        return Triplet.create(first, second, third);
    }

    private Nucleotide getNextNucleotide(Iterator<Nucleotide> iter) {
        if (!iter.hasNext()) {
            return null;
        }
        Nucleotide n = iter.next();
        return n;
    }

    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    private Iterator<Nucleotide> handleFrame(NucleotideSequence sequence, Frame frame) {
        Iterator<Object> iter;
        block12: {
            block11: {
                if (!frame.onReverseStrand()) break block11;
                iter = sequence.toBuilder().reverseComplement().iterator();
                switch (frame) {
                    case NEGATIVE_THREE: {
                        if (iter.hasNext()) {
                            iter.next();
                        }
                    }
                    case NEGATIVE_TWO: {
                        if (iter.hasNext()) {
                            iter.next();
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block12;
            }
            iter = sequence.iterator();
            switch (frame) {
                case THREE: {
                    if (iter.hasNext()) {
                        iter.next();
                    }
                }
                case TWO: {
                    if (!iter.hasNext()) break;
                    iter.next();
                    break;
                }
            }
        }
        return iter;
    }

    static {
        VALUES = Frame.values();
        FORWARDS = new ArrayList<Frame>(Arrays.asList(ONE, TWO, THREE));
        REVERSE = new ArrayList<Frame>(Arrays.asList(NEGATIVE_ONE, NEGATIVE_TWO, NEGATIVE_THREE));
    }
}

