/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.qual;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalDouble;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.RunLengthEncodedQualityCodec;

class RunLengthEncodedQualitySequence
implements QualitySequence {
    private final byte[] encodedData;
    private int hash;

    public RunLengthEncodedQualitySequence(byte[] encodedData) {
        this.encodedData = encodedData;
    }

    @Override
    public PhredQuality get(long index) {
        return RunLengthEncodedQualityCodec.INSTANCE.decode(this.encodedData, index);
    }

    @Override
    public long getLength() {
        return RunLengthEncodedQualityCodec.INSTANCE.decodedLengthOf(this.encodedData);
    }

    @Override
    public Iterator<PhredQuality> iterator(Range range) {
        return RunLengthEncodedQualityCodec.INSTANCE.iterator(this.encodedData, range);
    }

    @Override
    public Iterator<PhredQuality> iterator() {
        return RunLengthEncodedQualityCodec.INSTANCE.iterator(this.encodedData);
    }

    @Override
    public int hashCode() {
        if (this.hash == 0 && this.getLength() > 0L) {
            this.hash = Arrays.hashCode(this.toArray());
        }
        return this.hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QualitySequence)) {
            return false;
        }
        QualitySequence other = (QualitySequence)obj;
        return Arrays.equals(this.toArray(), other.toArray());
    }

    public String toString() {
        byte[] values = this.toArray();
        StringBuilder builder = new StringBuilder(values.length * 5);
        int lastOffset = values.length - 1;
        for (int i = 0; i < lastOffset; ++i) {
            builder.append(PhredQuality.toString(values[i])).append(" ,");
        }
        builder.append(PhredQuality.toString(values[lastOffset]));
        return builder.toString();
    }

    @Override
    public byte[] toArray() {
        return RunLengthEncodedQualityCodec.INSTANCE.toQualityValueArray(this.encodedData);
    }

    @Override
    public OptionalDouble getAvgQuality() {
        return RunLengthEncodedQualityCodec.INSTANCE.getAvgQuality(this.encodedData);
    }

    @Override
    public Optional<PhredQuality> getMinQuality() {
        return RunLengthEncodedQualityCodec.INSTANCE.getMinQuality(this.encodedData);
    }

    @Override
    public Optional<PhredQuality> getMaxQuality() {
        return RunLengthEncodedQualityCodec.INSTANCE.getMaxQuality(this.encodedData);
    }
}

