/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.qual;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalDouble;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySymbolCodec;
import org.jcvi.jillion.internal.core.io.ValueSizeStrategy;
import org.jcvi.jillion.internal.core.util.RunLength;

final class RunLengthEncodedQualityCodec
implements QualitySymbolCodec {
    public static final RunLengthEncodedQualityCodec INSTANCE = new RunLengthEncodedQualityCodec(-128);
    private final byte guard;

    RunLengthEncodedQualityCodec(byte guard) {
        this.guard = guard;
    }

    public Iterator<PhredQuality> iterator(byte[] encodedData) {
        ByteBuffer buf = ByteBuffer.wrap(encodedData);
        int size = buf.getInt();
        byte guard = buf.get();
        ValueSizeStrategy valueSizeStrategy = ValueSizeStrategy.values()[buf.get()];
        return new RunLengthIterator(buf, guard, valueSizeStrategy, size);
    }

    public Iterator<PhredQuality> iterator(byte[] encodedData, Range r) {
        ByteBuffer buf = ByteBuffer.wrap(encodedData);
        int size = buf.getInt();
        if (r.getEnd() > (long)(size - 1)) {
            throw new IndexOutOfBoundsException(String.format("can not iterate over %s when sequence is only %d long", r, size));
        }
        byte guard = buf.get();
        ValueSizeStrategy valueSizeStrategy = ValueSizeStrategy.values()[buf.get()];
        return new RunLengthIterator(buf, guard, valueSizeStrategy, r.getEnd() + 1L, r.getBegin());
    }

    private PhredQuality get(ByteBuffer buf, byte guard, ValueSizeStrategy valueSizeStrategy, long index) {
        int currentOffset = 0;
        while (buf.hasRemaining()) {
            byte currentValue;
            byte runLengthCode = buf.get();
            if (runLengthCode == guard) {
                int count = valueSizeStrategy.getNext(buf);
                if (count == 0) {
                    ++currentOffset;
                    currentValue = guard;
                } else {
                    currentValue = buf.get();
                    currentOffset += count;
                }
            } else {
                ++currentOffset;
                currentValue = runLengthCode;
            }
            if ((long)currentOffset <= index) continue;
            return PhredQuality.valueOf(currentValue);
        }
        throw new IndexOutOfBoundsException("could not find index " + index);
    }

    @Override
    public PhredQuality decode(byte[] encodedGlyphs, long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("can not have negative length");
        }
        ByteBuffer buf = ByteBuffer.wrap(encodedGlyphs);
        int length = buf.getInt();
        if (index >= (long)length) {
            throw new IndexOutOfBoundsException("can not have index beyond length");
        }
        byte guard = buf.get();
        ValueSizeStrategy valueSizeStrategy = ValueSizeStrategy.values()[buf.get()];
        return this.get(buf, guard, valueSizeStrategy, index);
    }

    @Override
    public int decodedLengthOf(byte[] encodedGlyphs) {
        ByteBuffer buf = ByteBuffer.wrap(encodedGlyphs);
        return buf.getInt();
    }

    @Override
    public byte[] encode(Collection<PhredQuality> glyphs) {
        List<RunLength<PhredQuality>> runLengthList = RunLengthEncodedQualityCodec.runLengthEncode(glyphs);
        return this.createEncodedByteArray(glyphs.size(), runLengthList);
    }

    public byte[] encode(byte[] qualities) {
        List<RunLength<PhredQuality>> runLengthList = RunLengthEncodedQualityCodec.runLengthEncode(qualities);
        return this.createEncodedByteArray(qualities.length, runLengthList);
    }

    public byte[] encode(Iterable<PhredQuality> qualityIterable, int numberOfQualities) {
        List<RunLength<PhredQuality>> runLengthList = RunLengthEncodedQualityCodec.runLengthEncode(qualityIterable);
        return this.createEncodedByteArray(numberOfQualities, runLengthList);
    }

    private byte[] createEncodedByteArray(int numberOfQualities, List<RunLength<PhredQuality>> runLengthList) {
        Metrics metrics = new Metrics(runLengthList);
        ValueSizeStrategy sizeStrategy = metrics.getSizeStrategy();
        ByteBuffer buf = ByteBuffer.allocate(metrics.computeEncodingSize());
        buf.putInt(numberOfQualities);
        buf.put(this.guard);
        buf.put((byte)sizeStrategy.ordinal());
        for (RunLength<PhredQuality> runLength : runLengthList) {
            if (runLength.getValue().getQualityScore() == this.guard) {
                for (int repeatCount = 0; repeatCount < runLength.getLength(); ++repeatCount) {
                    buf.put(this.guard);
                    sizeStrategy.put(buf, 0);
                }
                continue;
            }
            if (runLength.getLength() == 1) {
                buf.put(runLength.getValue().getQualityScore());
                continue;
            }
            buf.put(this.guard);
            sizeStrategy.put(buf, runLength.getLength());
            buf.put(runLength.getValue().getQualityScore());
        }
        return buf.array();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.guard;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RunLengthEncodedQualityCodec)) {
            return false;
        }
        RunLengthEncodedQualityCodec other = (RunLengthEncodedQualityCodec)obj;
        return this.guard == other.guard;
    }

    private static List<RunLength<PhredQuality>> runLengthEncode(byte[] qualities) {
        int currentOffset = 0;
        if (qualities.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<RunLength<PhredQuality>> encoding = new ArrayList<RunLength<PhredQuality>>(qualities.length);
        byte currentElement = qualities[currentOffset];
        int runLength = 1;
        ++currentOffset;
        while (currentOffset < qualities.length) {
            byte nextElement = qualities[currentOffset];
            if (currentElement == nextElement) {
                ++runLength;
            } else {
                encoding.add(new RunLength<PhredQuality>(PhredQuality.valueOf(currentElement), runLength));
                runLength = 1;
                currentElement = nextElement;
            }
            ++currentOffset;
        }
        encoding.add(new RunLength<PhredQuality>(PhredQuality.valueOf(currentElement), runLength));
        return encoding;
    }

    private static <T> List<RunLength<T>> runLengthEncode(Iterable<T> elements) {
        Iterator<T> iter = elements.iterator();
        if (!iter.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<RunLength<T>> encoding = new ArrayList<RunLength<T>>();
        T currentElement = iter.next();
        int runLength = 1;
        while (iter.hasNext()) {
            T nextElement = iter.next();
            if (currentElement.equals(nextElement)) {
                ++runLength;
                continue;
            }
            encoding.add(new RunLength<T>(currentElement, runLength));
            runLength = 1;
            currentElement = nextElement;
        }
        encoding.add(new RunLength<T>(currentElement, runLength));
        return encoding;
    }

    @Override
    public OptionalDouble getAvgQuality(byte[] encodedData) {
        ByteBuffer buf = ByteBuffer.wrap(encodedData);
        int length = buf.getInt();
        if (length == 0) {
            return OptionalDouble.empty();
        }
        byte guard = buf.get();
        ValueSizeStrategy valueSizeStrategy = ValueSizeStrategy.values()[buf.get()];
        long sum = 0L;
        int currentOffset = 0;
        while (currentOffset < length) {
            int endOffset;
            byte currentValue;
            int runLength;
            byte runLengthCode = buf.get();
            if (runLengthCode == guard) {
                int count = valueSizeStrategy.getNext(buf);
                if (count == 0) {
                    runLength = 1;
                    currentValue = guard;
                } else {
                    currentValue = buf.get();
                    runLength = count;
                }
            } else {
                runLength = 1;
                currentValue = runLengthCode;
            }
            sum += (long)(currentValue * runLength);
            currentOffset = endOffset = currentOffset + runLength;
        }
        return OptionalDouble.of((double)sum / (double)length);
    }

    @Override
    public Optional<PhredQuality> getMinQuality(byte[] encodedData) {
        ByteBuffer buf = ByteBuffer.wrap(encodedData);
        int length = buf.getInt();
        if (length == 0) {
            return Optional.empty();
        }
        byte guard = buf.get();
        ValueSizeStrategy valueSizeStrategy = ValueSizeStrategy.values()[buf.get()];
        byte min = 127;
        int currentOffset = 0;
        while (currentOffset < length) {
            int endOffset;
            byte currentValue;
            int runLength;
            byte runLengthCode = buf.get();
            if (runLengthCode == guard) {
                int count = valueSizeStrategy.getNext(buf);
                if (count == 0) {
                    runLength = 1;
                    currentValue = guard;
                } else {
                    currentValue = buf.get();
                    runLength = count;
                }
            } else {
                runLength = 1;
                currentValue = runLengthCode;
            }
            if (currentValue < min) {
                min = currentValue;
            }
            currentOffset = endOffset = currentOffset + runLength;
        }
        return Optional.of(PhredQuality.valueOf(min));
    }

    @Override
    public Optional<PhredQuality> getMaxQuality(byte[] encodedData) {
        ByteBuffer buf = ByteBuffer.wrap(encodedData);
        int length = buf.getInt();
        if (length == 0) {
            return Optional.empty();
        }
        byte guard = buf.get();
        ValueSizeStrategy valueSizeStrategy = ValueSizeStrategy.values()[buf.get()];
        byte max = 0;
        int currentOffset = 0;
        while (currentOffset < length) {
            int endOffset;
            byte currentValue;
            int runLength;
            byte runLengthCode = buf.get();
            if (runLengthCode == guard) {
                int count = valueSizeStrategy.getNext(buf);
                if (count == 0) {
                    runLength = 1;
                    currentValue = guard;
                } else {
                    currentValue = buf.get();
                    runLength = count;
                }
            } else {
                runLength = 1;
                currentValue = runLengthCode;
            }
            if (currentValue > max) {
                max = currentValue;
            }
            currentOffset = endOffset = currentOffset + runLength;
        }
        return Optional.of(PhredQuality.valueOf(max));
    }

    @Override
    public byte[] toQualityValueArray(byte[] encodedData) {
        ByteBuffer buf = ByteBuffer.wrap(encodedData);
        int length = buf.getInt();
        if (length == 0) {
            return new byte[0];
        }
        byte[] result = new byte[length];
        byte guard = buf.get();
        ValueSizeStrategy valueSizeStrategy = ValueSizeStrategy.values()[buf.get()];
        int currentOffset = 0;
        while (currentOffset < length) {
            byte currentValue;
            int runLength;
            byte runLengthCode = buf.get();
            if (runLengthCode == guard) {
                int count = valueSizeStrategy.getNext(buf);
                if (count == 0) {
                    runLength = 1;
                    currentValue = guard;
                } else {
                    currentValue = buf.get();
                    runLength = count;
                }
            } else {
                runLength = 1;
                currentValue = runLengthCode;
            }
            int endOffset = currentOffset + runLength;
            Arrays.fill(result, currentOffset, endOffset, currentValue);
            currentOffset = endOffset;
        }
        return result;
    }

    private class Metrics {
        private int numGuards = 0;
        private int singletons = 0;
        private int nonSingletons = 0;
        private int maxRunLength = 0;
        private final ValueSizeStrategy sizeStrategy;

        public Metrics(List<RunLength<PhredQuality>> runLengthList) {
            for (RunLength<PhredQuality> runLength : runLengthList) {
                int length = runLength.getLength();
                if (length > this.maxRunLength) {
                    this.maxRunLength = length;
                }
                if (runLength.getValue().getQualityScore() == RunLengthEncodedQualityCodec.this.guard) {
                    this.numGuards += length;
                    continue;
                }
                if (length == 1) {
                    ++this.singletons;
                    continue;
                }
                ++this.nonSingletons;
            }
            this.sizeStrategy = ValueSizeStrategy.getStrategyFor(this.maxRunLength);
        }

        public int computeEncodingSize() {
            int bytesPerLength = this.sizeStrategy.getNumberOfBytesPerValue();
            int header = 6;
            int sizeOfGuardedSections = this.numGuards * (bytesPerLength + 1);
            int sizeOfSingletons = this.singletons;
            int sizeOfNonSingletons = this.nonSingletons * (bytesPerLength + 2);
            return header + sizeOfGuardedSections + sizeOfSingletons + sizeOfNonSingletons;
        }

        public final ValueSizeStrategy getSizeStrategy() {
            return this.sizeStrategy;
        }
    }

    private static final class RunLengthIterator
    implements Iterator<PhredQuality> {
        private long currentOffset;
        private final ByteBuffer buf;
        private final byte guard;
        private final long length;
        private PhredQuality currentQuality;
        private int currentRunEndOffset;
        private final ValueSizeStrategy valueSizeStrategy;

        RunLengthIterator(ByteBuffer buf, byte guard, ValueSizeStrategy valueSizeStrategy, long length) {
            this(buf, guard, valueSizeStrategy, length, 0L);
        }

        RunLengthIterator(ByteBuffer buf, byte guard, ValueSizeStrategy valueSizeStrategy, long length, long startOffset) {
            this.buf = buf;
            this.guard = guard;
            this.valueSizeStrategy = valueSizeStrategy;
            this.currentOffset = startOffset;
            this.length = length;
            this.populateCurrentRun();
            while (this.currentOffset >= (long)this.currentRunEndOffset) {
                this.populateCurrentRun();
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentOffset < this.length;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PhredQuality next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("offset = " + this.currentOffset);
            }
            if (this.currentOffset >= (long)this.currentRunEndOffset) {
                this.populateCurrentRun();
            }
            ++this.currentOffset;
            return this.currentQuality;
        }

        private void populateCurrentRun() {
            byte currentValue;
            byte runLengthCode = this.buf.get();
            if (runLengthCode == this.guard) {
                int count = this.valueSizeStrategy.getNext(this.buf);
                if (count == 0) {
                    ++this.currentRunEndOffset;
                    currentValue = this.guard;
                } else {
                    currentValue = this.buf.get();
                    this.currentRunEndOffset += count;
                }
            } else {
                ++this.currentRunEndOffset;
                currentValue = runLengthCode;
            }
            this.currentQuality = PhredQuality.valueOf(currentValue);
        }
    }
}

