/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.qual;

import java.util.Iterator;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.SequenceBuilder;
import org.jcvi.jillion.core.qual.DefaultQualitySymbolCodec;
import org.jcvi.jillion.core.qual.EncodedQualitySequence;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.RunLengthEncodedQualityCodec;
import org.jcvi.jillion.core.qual.RunLengthEncodedQualitySequence;
import org.jcvi.jillion.internal.core.util.GrowableByteArray;

public final class QualitySequenceBuilder
implements SequenceBuilder<PhredQuality, QualitySequence> {
    private static final int DEFAULT_CAPACITY = 200;
    private GrowableByteArray builder;
    private boolean turnOffDataCompression = false;

    public QualitySequenceBuilder() {
        this(200);
    }

    public QualitySequenceBuilder(int initialCapacity) {
        this.builder = new GrowableByteArray(initialCapacity);
    }

    public QualitySequenceBuilder(byte[] initialqualities) {
        this.builder = new GrowableByteArray(initialqualities);
    }

    public QualitySequenceBuilder clear() {
        this.builder.clear();
        return this;
    }

    public QualitySequenceBuilder(Iterable<PhredQuality> qualitySequence) {
        this();
        for (PhredQuality q : qualitySequence) {
            this.append(q);
        }
    }

    public QualitySequenceBuilder(QualitySequence qualitySequence) {
        this.builder = new GrowableByteArray(qualitySequence.toArray());
    }

    public QualitySequenceBuilder(QualitySequence qualitySequence, Range range) {
        this.builder = new GrowableByteArray(qualitySequence.toArray(range));
    }

    private QualitySequenceBuilder(QualitySequenceBuilder copy) {
        this.builder = copy.builder.copy();
    }

    @Override
    public PhredQuality get(int offset) {
        this.assertInsertOffsetValid(offset);
        return PhredQuality.valueOf(this.builder.get(offset));
    }

    public QualitySequenceBuilder append(PhredQuality quality) {
        this.builder.append(quality.getQualityScore());
        return this;
    }

    public QualitySequenceBuilder append(QualitySequenceBuilder other) {
        this.builder.append(other.builder);
        return this;
    }

    public QualitySequenceBuilder append(int qualityScore) {
        return this.append(PhredQuality.valueOf(qualityScore));
    }

    public QualitySequenceBuilder append(byte[] qualityScores) {
        this.builder.append(qualityScores);
        return this;
    }

    public QualitySequenceBuilder append(QualitySequence sequence) {
        this.builder.append(sequence.toArray());
        return this;
    }

    @Override
    public long getLength() {
        return this.builder.getCurrentLength();
    }

    public QualitySequenceBuilder replace(int offset, PhredQuality replacement) {
        this.builder.replace(offset, replacement.getQualityScore());
        return this;
    }

    public QualitySequenceBuilder delete(Range range) {
        this.builder.remove(range);
        return this;
    }

    public QualitySequenceBuilder insert(int offset, QualitySequenceBuilder otherBuilder) {
        this.assertInsertOffsetValid(offset);
        this.builder.insert(offset, otherBuilder.builder);
        return this;
    }

    public QualitySequenceBuilder insert(int offset, QualitySequence sequence) {
        this.builder.insert(offset, sequence.toArray());
        return this;
    }

    public QualitySequenceBuilder insert(int offset, PhredQuality qualityScore) {
        this.assertInsertOffsetValid(offset);
        this.builder.insert(offset, qualityScore.getQualityScore());
        return this;
    }

    public QualitySequenceBuilder insert(int offset, byte[] qualityScores) {
        this.assertInsertOffsetValid(offset);
        this.builder.insert(offset, qualityScores);
        return this;
    }

    private void assertInsertOffsetValid(int offset) {
        if (offset < 0 || (long)offset > this.getLength()) {
            throw new IndexOutOfBoundsException(String.format("invalid offset %d only values between 0 and %d are allowed", offset, this.getLength()));
        }
    }

    public QualitySequenceBuilder turnOffDataCompression(boolean turnOffDataCompression) {
        this.turnOffDataCompression = turnOffDataCompression;
        return this;
    }

    @Override
    public QualitySequence build() {
        byte[] runLengthEncoded;
        byte[] array = this.builder.toArray();
        if (!this.turnOffDataCompression && (runLengthEncoded = RunLengthEncodedQualityCodec.INSTANCE.encode(array)).length < this.builder.getCurrentLength()) {
            return new RunLengthEncodedQualitySequence(runLengthEncoded);
        }
        return new EncodedQualitySequence(DefaultQualitySymbolCodec.INSTANCE, array);
    }

    public QualitySequenceBuilder trim(Range range) {
        Range fullRange = Range.ofLength(this.builder.getCurrentLength());
        if (range.isEmpty()) {
            this.builder.remove(fullRange);
            return this;
        }
        Range insersection = fullRange.intersection(range);
        Range right = Range.of(insersection.getEnd() + 1L, (long)(this.builder.getCurrentLength() - 1));
        Range left = Range.of(0L, insersection.getBegin() - 1L);
        this.builder.remove(right);
        this.builder.remove(left);
        return this;
    }

    public QualitySequenceBuilder copy() {
        return new QualitySequenceBuilder(this);
    }

    public QualitySequenceBuilder reverse() {
        this.builder.reverse();
        return this;
    }

    public QualitySequenceBuilder prepend(int qualityScore) {
        return this.insert(0, PhredQuality.valueOf(qualityScore));
    }

    public QualitySequenceBuilder prepend(byte[] qualityScores) {
        return this.insert(0, qualityScores);
    }

    public QualitySequenceBuilder prepend(QualitySequenceBuilder otherBuilder) {
        return this.insert(0, otherBuilder);
    }

    public QualitySequenceBuilder prepend(QualitySequence sequence) {
        return this.insert(0, sequence);
    }

    @Override
    public Iterator<PhredQuality> iterator() {
        return new IteratorImpl();
    }

    public Iterator<PhredQuality> iterator(Range range) {
        return new IteratorImpl(range);
    }

    public byte[] toArray() {
        return this.builder.toArray();
    }

    private class IteratorImpl
    implements Iterator<PhredQuality> {
        private int currentOffset;
        private int endOffset;

        public IteratorImpl() {
            this.currentOffset = 0;
            this.endOffset = QualitySequenceBuilder.this.builder.getCurrentLength() - 1;
        }

        public IteratorImpl(Range range) {
            this.currentOffset = Math.max(0, (int)range.getBegin());
            this.endOffset = Math.min(QualitySequenceBuilder.this.builder.getCurrentLength() - 1, (int)range.getEnd());
        }

        @Override
        public boolean hasNext() {
            return this.currentOffset <= this.endOffset;
        }

        @Override
        public PhredQuality next() {
            PhredQuality next = PhredQuality.valueOf(QualitySequenceBuilder.this.builder.get(this.currentOffset));
            ++this.currentOffset;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

