/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.qual;

import java.util.Arrays;
import java.util.DoubleSummaryStatistics;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.Sequence;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;

public interface QualitySequence
extends Sequence<PhredQuality> {
    @Override
    public boolean equals(Object var1);

    @Override
    public int hashCode();

    public byte[] toArray();

    default public byte[] toArray(Range range) {
        return Arrays.copyOfRange(this.toArray(), (int)range.getBegin(), (int)range.getEnd() + 1);
    }

    public OptionalDouble getAvgQuality();

    public Optional<PhredQuality> getMinQuality();

    public Optional<PhredQuality> getMaxQuality();

    default public QualitySequenceBuilder toBuilder() {
        return new QualitySequenceBuilder(this);
    }

    default public Optional<DoubleSummaryStatistics> getSummaryStats() {
        if (this.getLength() <= 0L) {
            return Optional.empty();
        }
        return Optional.of(StreamSupport.stream(this.spliterator(), false).collect(Collectors.summarizingDouble(PhredQuality::getQualityScore)));
    }

    default public Optional<DoubleSummaryStatistics> getSummaryStats(Range subRange) {
        Iterator iter = this.iterator(subRange);
        if (!iter.hasNext()) {
            return Optional.empty();
        }
        return Optional.of(StreamSupport.stream(Spliterators.spliteratorUnknownSize(iter, 16), false).collect(Collectors.summarizingDouble(PhredQuality::getQualityScore)));
    }
}

