/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.qual;

import java.nio.ByteBuffer;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.internal.core.util.JillionUtil;

public final class PhredQuality
implements Comparable<PhredQuality> {
    public static final byte MAX_VALUE = 127;
    public static final byte MIN_VALUE = 0;
    private static final double TEN = 10.0;
    private static final PhredQuality[] CACHE = new PhredQuality[128];
    private final byte value;

    private PhredQuality(byte b) {
        this.value = b;
    }

    @Override
    public int compareTo(PhredQuality other) {
        return JillionUtil.compare(this.value, other.value);
    }

    @Override
    public int compareTo(double qualityValue) {
        return Double.compare(this.value, qualityValue);
    }

    public static PhredQuality withErrorProbability(double errorProbability) {
        return PhredQuality.valueOf(PhredQuality.computeQualityScore(errorProbability));
    }

    public static int computeQualityScore(double errorProbability) {
        if (errorProbability <= 0.0) {
            throw new IllegalArgumentException("probability must be > 0 : " + errorProbability);
        }
        if (errorProbability >= 1.0) {
            throw new IllegalArgumentException("probability must be < 1: " + errorProbability);
        }
        return (int)Math.round(-10.0 * Math.log10(errorProbability));
    }

    public double getErrorProbability() {
        return Math.pow(10.0, (double)this.value / -10.0);
    }

    public byte getQualityScore() {
        return this.value;
    }

    public static PhredQuality valueOf(int qualityScore) {
        PhredQuality.validate(qualityScore);
        return CACHE[qualityScore];
    }

    private static void validate(int qualityScore) {
        if (qualityScore < 0 || qualityScore > 127) {
            throw new IllegalArgumentException("qualityScore of our range " + qualityScore);
        }
    }

    public static byte[] toArray(QualitySequence qualities) {
        ByteBuffer buf = ByteBuffer.allocate((int)qualities.getLength());
        for (PhredQuality quality : qualities) {
            buf.put(quality.value);
        }
        return buf.array();
    }

    public String toString() {
        return PhredQuality.toStringValidValue(this.value);
    }

    public static String toString(byte qualityValue) {
        PhredQuality.validate(qualityValue);
        return PhredQuality.toStringValidValue(qualityValue);
    }

    private static String toStringValidValue(byte qualityValue) {
        return String.format("Q%02d", qualityValue);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhredQuality)) {
            return false;
        }
        PhredQuality other = (PhredQuality)obj;
        return this.value == other.value;
    }

    static {
        for (byte b = 0; b >= 0 && b <= 127; b = (byte)(b + 1)) {
            PhredQuality.CACHE[b] = new PhredQuality(b);
        }
    }
}

