/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.qual;

import java.util.Optional;
import java.util.OptionalDouble;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.qual.QualitySymbolCodec;
import org.jcvi.jillion.internal.core.EncodedSequence;

final class EncodedQualitySequence
extends EncodedSequence<PhredQuality>
implements QualitySequence {
    private Stats stats;

    public EncodedQualitySequence(QualitySymbolCodec codec, byte[] data) {
        super(codec, data);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QualitySequence)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public byte[] toArray() {
        return ((QualitySymbolCodec)this.getCodec()).toQualityValueArray(this.data);
    }

    @Override
    public OptionalDouble getAvgQuality() {
        this.computeStatsIfNeeded();
        if (this.stats.avg < 0.0) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(this.stats.avg);
    }

    @Override
    public Optional<PhredQuality> getMinQuality() {
        this.computeStatsIfNeeded();
        byte value = this.stats.min;
        if (value < 0) {
            return Optional.empty();
        }
        return Optional.of(PhredQuality.valueOf(value));
    }

    @Override
    public Optional<PhredQuality> getMaxQuality() {
        this.computeStatsIfNeeded();
        byte value = this.stats.max;
        if (value < 0) {
            return Optional.empty();
        }
        return Optional.of(PhredQuality.valueOf(value));
    }

    private void computeStatsIfNeeded() {
        if (this.stats != null) {
            return;
        }
        byte[] array = this.toArray();
        if (array.length == 0) {
            this.stats = new Stats(-1, -1, -1.0);
            return;
        }
        byte min = 127;
        byte max = -128;
        long total = 0L;
        for (int i = 0; i < array.length; ++i) {
            byte v = array[i];
            if (v < min) {
                min = v;
            }
            if (v > max) {
                max = v;
            }
            total += (long)v;
        }
        this.stats = new Stats(min, max, (double)total / (double)array.length);
    }

    @Override
    public QualitySequenceBuilder toBuilder() {
        return QualitySequence.super.toBuilder();
    }

    private static class Stats {
        private final byte min;
        private final byte max;
        private final double avg;

        protected Stats(byte min, byte max, double avg) {
            this.min = min;
            this.max = max;
            this.avg = avg;
        }
    }
}

