/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.qual;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Optional;
import java.util.OptionalDouble;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySymbolCodec;

enum DefaultQualitySymbolCodec implements QualitySymbolCodec
{
    INSTANCE;


    @Override
    public PhredQuality decode(byte[] encodedGlyphs, long index) {
        return PhredQuality.valueOf(encodedGlyphs[(int)index]);
    }

    @Override
    public int decodedLengthOf(byte[] encodedGlyphs) {
        return encodedGlyphs.length;
    }

    @Override
    public byte[] encode(Collection<PhredQuality> glyphs) {
        ByteBuffer buf = ByteBuffer.allocate(glyphs.size());
        for (PhredQuality g : glyphs) {
            buf.put(g.getQualityScore());
        }
        return buf.array();
    }

    @Override
    public byte[] toQualityValueArray(byte[] encodedData) {
        byte[] decoded = new byte[encodedData.length];
        System.arraycopy(encodedData, 0, decoded, 0, decoded.length);
        return decoded;
    }

    @Override
    public OptionalDouble getAvgQuality(byte[] encodedData) {
        if (encodedData.length == 0) {
            return OptionalDouble.empty();
        }
        long sum = 0L;
        for (int i = 0; i < encodedData.length; ++i) {
            sum += (long)encodedData[i];
        }
        return OptionalDouble.of((double)sum / (double)encodedData.length);
    }

    @Override
    public Optional<PhredQuality> getMinQuality(byte[] encodedData) {
        if (encodedData.length == 0) {
            return Optional.empty();
        }
        byte min = 127;
        for (int i = 0; i < encodedData.length; ++i) {
            byte current = encodedData[i];
            if (current >= min) continue;
            min = current;
        }
        return Optional.of(PhredQuality.valueOf(min));
    }

    @Override
    public Optional<PhredQuality> getMaxQuality(byte[] encodedData) {
        if (encodedData.length == 0) {
            return Optional.empty();
        }
        byte max = 0;
        for (int i = 0; i < encodedData.length; ++i) {
            byte current = encodedData[i];
            if (current <= max) continue;
            max = current;
        }
        return Optional.of(PhredQuality.valueOf(max));
    }
}

