/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.pos;

import java.util.Iterator;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.SequenceBuilder;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.pos.DefaultPositionSequence;
import org.jcvi.jillion.core.pos.Position;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.internal.core.util.GrowableShortArray;

public final class PositionSequenceBuilder
implements SequenceBuilder<Position, PositionSequence> {
    private static final int DEFAULT_PEAK_CAPACITY = 800;
    private GrowableShortArray builder;

    public PositionSequenceBuilder() {
        this(800);
    }

    public PositionSequenceBuilder(int initialCapacity) {
        this.builder = new GrowableShortArray(initialCapacity);
    }

    public PositionSequenceBuilder(short[] initialPositions) {
        this.builder = new GrowableShortArray(initialPositions);
    }

    public PositionSequenceBuilder(PositionSequence positionSequence) {
        this.builder = new GrowableShortArray(positionSequence.toArray());
    }

    private PositionSequenceBuilder(PositionSequenceBuilder copy) {
        this.builder = copy.builder.copy();
    }

    public PositionSequenceBuilder clear() {
        this.builder.clear();
        return this;
    }

    private short encode(Position q) {
        return IOUtil.toSignedShort(q.getValue());
    }

    @Override
    public PositionSequence build() {
        return new DefaultPositionSequence(this.builder.toArray());
    }

    public PositionSequenceBuilder append(Position position) {
        this.builder.append(this.encode(position));
        return this;
    }

    public PositionSequenceBuilder append(PositionSequenceBuilder other) {
        this.builder.append(other.builder);
        return this;
    }

    public PositionSequenceBuilder append(int positionValue) {
        return this.append(Position.valueOf(positionValue));
    }

    public PositionSequenceBuilder append(short[] positionValues) {
        this.builder.append(positionValues);
        return this;
    }

    public PositionSequenceBuilder append(PositionSequence sequence) {
        this.builder.append(sequence.toArray());
        return this;
    }

    @Override
    public long getLength() {
        return this.builder.getCurrentLength();
    }

    public PositionSequenceBuilder replace(int offset, Position replacement) {
        this.builder.replace(offset, this.encode(replacement));
        return this;
    }

    public PositionSequenceBuilder delete(Range range) {
        this.builder.remove(range);
        return this;
    }

    public PositionSequenceBuilder insert(int offset, PositionSequenceBuilder otherBuilder) {
        this.assertInsertOffsetValid(offset);
        this.builder.insert(offset, otherBuilder.builder);
        return this;
    }

    public PositionSequenceBuilder insert(int offset, PositionSequence sequence) {
        this.builder.insert(offset, sequence.toArray());
        return this;
    }

    @Override
    public Position get(int offset) {
        this.assertInsertOffsetValid(offset);
        return Position.valueOf(this.builder.get(offset));
    }

    public PositionSequenceBuilder insert(int offset, Position positionScore) {
        this.assertInsertOffsetValid(offset);
        this.builder.insert(offset, this.encode(positionScore));
        return this;
    }

    public PositionSequenceBuilder insert(int offset, short[] positionValues) {
        this.assertInsertOffsetValid(offset);
        this.builder.insert(offset, positionValues);
        return this;
    }

    private void assertInsertOffsetValid(int offset) {
        if (offset < 0 || (long)offset > this.getLength()) {
            throw new IndexOutOfBoundsException(String.format("invalid offset %d only values between 0 and %d are allowed", offset, this.getLength()));
        }
    }

    public PositionSequenceBuilder trim(Range range) {
        if (range.isEmpty()) {
            this.builder.remove(Range.ofLength(this.getLength()));
            return this;
        }
        Range right = Range.of(range.getEnd() + 1L, (long)(this.builder.getCurrentLength() - 1));
        Range left = Range.of(0L, range.getBegin() - 1L);
        this.builder.remove(right);
        this.builder.remove(left);
        return this;
    }

    public PositionSequenceBuilder copy() {
        return new PositionSequenceBuilder(this);
    }

    public PositionSequenceBuilder reverse() {
        this.builder.reverse();
        return this;
    }

    public PositionSequenceBuilder prepend(int positionValue) {
        return this.insert(0, Position.valueOf(positionValue));
    }

    public PositionSequenceBuilder prepend(short[] positionValues) {
        return this.insert(0, positionValues);
    }

    public PositionSequenceBuilder prepend(PositionSequenceBuilder otherBuilder) {
        return this.insert(0, otherBuilder);
    }

    public PositionSequenceBuilder prepend(PositionSequence sequence) {
        return this.insert(0, sequence);
    }

    @Override
    public Iterator<Position> iterator() {
        return new IteratorImpl();
    }

    private class IteratorImpl
    implements Iterator<Position> {
        private int currentOffset = 0;

        private IteratorImpl() {
        }

        @Override
        public boolean hasNext() {
            return this.currentOffset < PositionSequenceBuilder.this.builder.getCurrentLength();
        }

        @Override
        public Position next() {
            Position next = Position.valueOf(IOUtil.toUnsignedShort(PositionSequenceBuilder.this.builder.get(this.currentOffset)));
            ++this.currentOffset;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

