/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.pos;

public final class Position {
    private static final int INITIAL_CACHE_SIZE = 20000;
    private static final Position[] CACHE = new Position[20000];
    private final int value;

    public static Position valueOf(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("position value can not be negative");
        }
        if (value < CACHE.length) {
            return CACHE[value];
        }
        return new Position(value);
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    private Position(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Position)) {
            return false;
        }
        Position other = (Position)obj;
        return this.value == other.value;
    }

    static {
        for (int i = 0; i < 20000; ++i) {
            Position.CACHE[i] = new Position(i);
        }
    }
}

