/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.pos;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.pos.Position;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.core.pos.PositionSequenceBuilder;

class DefaultPositionSequence
implements PositionSequence {
    private final short[] data;

    DefaultPositionSequence(short[] data) {
        this.data = data;
    }

    @Override
    public short[] toArray() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    @Override
    public Position get(long index) {
        return Position.valueOf(IOUtil.toUnsignedShort(this.data[(int)index]));
    }

    @Override
    public long getLength() {
        return this.data.length;
    }

    @Override
    public Iterator<Position> iterator(Range range) {
        return new IteratorImpl(range);
    }

    @Override
    public Iterator<Position> iterator() {
        return new IteratorImpl();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultPositionSequence)) {
            return false;
        }
        DefaultPositionSequence other = (DefaultPositionSequence)obj;
        return Arrays.equals(this.data, other.data);
    }

    public String toString() {
        return Arrays.toString(this.data);
    }

    public PositionSequenceBuilder toBuilder() {
        return new PositionSequenceBuilder(this);
    }

    private class IteratorImpl
    implements Iterator<Position> {
        private final int end;
        private int offset;

        IteratorImpl() {
            this.end = DefaultPositionSequence.this.data.length - 1;
            this.offset = 0;
        }

        IteratorImpl(Range range) {
            this.offset = (int)range.getBegin();
            this.end = (int)range.getEnd();
            if (this.offset < 0) {
                throw new IllegalArgumentException(String.format("range %s can not have negative values", range));
            }
            if (this.end > DefaultPositionSequence.this.data.length) {
                throw new IllegalArgumentException(String.format("range %s can not extend past sequence length %d", range, DefaultPositionSequence.this.data.length));
            }
        }

        @Override
        public boolean hasNext() {
            return this.offset <= this.end;
        }

        @Override
        public Position next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException(String.format("offset = %d", this.offset));
            }
            Position next = DefaultPositionSequence.this.get(this.offset);
            ++this.offset;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

