/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.pos;

import java.nio.ByteBuffer;
import java.util.Collection;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.pos.Position;
import org.jcvi.jillion.internal.core.GlyphCodec;

enum DefaultPositionCodec implements GlyphCodec<Position>
{
    INSTANCE;


    @Override
    public Position decode(byte[] encodedGlyphs, long index) {
        int indexIntoShortAray = (int)(index * 2L);
        int hi = encodedGlyphs[indexIntoShortAray] << 8;
        byte low = encodedGlyphs[indexIntoShortAray + 1];
        int value = hi | low & 0xFF;
        return Position.valueOf(IOUtil.toUnsignedShort((short)value));
    }

    @Override
    public int decodedLengthOf(byte[] encodedGlyphs) {
        return encodedGlyphs.length / 2;
    }

    public byte[] encode(Collection<Position> glyphs) {
        ByteBuffer buf = ByteBuffer.allocate(glyphs.size() * 2);
        for (Position g : glyphs) {
            buf.putShort(IOUtil.toSignedShort(g.getValue()));
        }
        return buf.array();
    }
}

