/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

class SubLengthInputStream
extends InputStream {
    private final InputStream in;
    private long bytesLeftToRead;

    public SubLengthInputStream(InputStream in, long lengthToRead) {
        Objects.requireNonNull(in);
        this.in = in;
        this.bytesLeftToRead = lengthToRead;
    }

    @Override
    public int read() throws IOException {
        if (this.bytesLeftToRead > 0L) {
            --this.bytesLeftToRead;
            return this.in.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bytesLeftToRead <= 0L) {
            return -1;
        }
        int bytesRead = this.in.read(b, off, (int)Math.min(this.bytesLeftToRead, (long)len));
        if (bytesRead != -1) {
            this.bytesLeftToRead -= (long)bytesRead;
        }
        return bytesRead;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

