/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.InputStreamSupplier;
import org.jcvi.jillion.internal.core.io.RandomAccessFileInputStream;

class RawFileInputStreamSupplier
implements InputStreamSupplier {
    private final File file;

    RawFileInputStreamSupplier(File file) {
        this.file = file;
    }

    @Override
    public InputStream get() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    @Override
    public Optional<File> getFile() {
        return Optional.of(this.file);
    }

    @Override
    public InputStream get(long startOffset) throws IOException {
        return new RandomAccessFileInputStream(this.file, startOffset);
    }

    @Override
    public InputStream get(Range range) throws IOException {
        return new RandomAccessFileInputStream(this.file, range.getBegin(), range.getLength());
    }
}

