/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Objects;

public class PushBackBufferedReader
extends BufferedReader {
    private final LinkedList<String> pushBackStack = new LinkedList();
    private volatile boolean isClosed;

    public PushBackBufferedReader(BufferedReader in) {
        super(in);
    }

    public void pushBack(String line) {
        this.pushBackStack.push(Objects.requireNonNull(line));
    }

    @Override
    public String readLine() throws IOException {
        if (this.isClosed) {
            return null;
        }
        if (!this.pushBackStack.isEmpty()) {
            return this.pushBackStack.pop();
        }
        return super.readLine();
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        super.close();
    }
}

