/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;

public final class OutputStreams {
    private static final int _8K = 8192;

    private OutputStreams() {
    }

    public static GZIPOutputStream gzip(File out) throws IOException {
        return OutputStreams.gzip(out, 8192);
    }

    public static GZIPOutputStream gzip(File out, int bufferSize) throws IOException {
        return new GZIPOutputStream((OutputStream)new FileOutputStream(out), bufferSize);
    }

    public static ZipOutputStream zip(File out, int bufferSize) throws IOException {
        return new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(out), bufferSize));
    }

    public static ZipOutputStream zip(File out) throws IOException {
        return new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(out)));
    }

    public static OutputStream raw(File out) throws IOException {
        return new FileOutputStream(out);
    }

    public static OutputStream buffered(File out) throws IOException {
        return new BufferedOutputStream(new FileOutputStream(out));
    }

    public static OutputStream buffered(File out, int bufferSize) throws IOException {
        return new BufferedOutputStream(new FileOutputStream(out), bufferSize);
    }
}

